/* Arquivo ContextoCompilacaoICABS.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 15/04/08: Criação do arquivo
 * Carlos Eduardo Pontual - 20/04/08: Os métodos mapAssinaturas, getParametrosAssinaturas
 * 		mapDefInterface e getDefInterface foram movidos de ContextoCompilacao.java para esta classe.
 * Carlos Eduardo Pontual - 21/04/08 - Alteração nos metodos que chamam 
 * 		ContextoExecucao.getElemento
 */

package plp.interfaceclasseabstrata.memoria;

import java.util.HashMap;
import java.util.Stack;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.ContextoExecucao;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;
import plp.orientadaObjetos2.memoria.ContextoCompilacaoOO2;

public class ContextoCompilacaoICABS extends ContextoCompilacaoOO2 implements AmbienteCompilacaoICABS {

	private HashMap<Id, Id> mapInterfaces;

	/**
	 * A pilha das assinaturas do contexto
	 */
	private Stack<HashMap<Id, ListaDeclaracaoParametro>> pilhaAssinaturas;

	/**
	 * A pilha de interfaces do contexto.
	 */
	private Stack<HashMap<Id, DefInterface>> pilhaDefInterfaces;

	public ContextoCompilacaoICABS(ListaValor entrada) {
		super(entrada);
		mapInterfaces = new HashMap<Id, Id>();

		pilhaAssinaturas = new Stack<HashMap<Id, ListaDeclaracaoParametro>>();
		pilhaAssinaturas.push(new HashMap<Id, ListaDeclaracaoParametro>());
		pilhaDefInterfaces = new Stack<HashMap<Id, DefInterface>>();
		pilhaDefInterfaces.push(new HashMap<Id, DefInterface>());
	}

	public DefInterface getImplementsClasse(Id classe) throws InterfaceNaoDeclaradaException {
		// TODO Auto-generated method stub
		return getDefInterface(mapInterfaces.get(classe));
	}

	public void mapImplementsClasse(Id classe, Id idInterface) {
		mapInterfaces.put(classe, idInterface);

	}

	public ListaDeclaracaoParametro getParametrosAssinatura(Id idArg) throws AssinaturaNaoDeclaradaException {
		return ContextoExecucao.getElemento(idArg, pilhaAssinaturas, new AssinaturaNaoDeclaradaException(idArg));
	}

	public void mapAssinaturas(Id idArg, ListaDeclaracaoParametro assinaturasId) throws AssinaturaJaDeclaradaException {
		HashMap<Id, ListaDeclaracaoParametro> aux = pilhaAssinaturas.peek();
		if (aux.put(idArg, assinaturasId) != null) {
			throw new AssinaturaJaDeclaradaException(idArg);
		}

	}

	public DefInterface getDefInterface(Id idArg) throws InterfaceNaoDeclaradaException {
		return ContextoExecucao.getElemento(idArg, pilhaDefInterfaces, new InterfaceNaoDeclaradaException(idArg));
	}

	public void mapDefInterface(Id idArg, DefInterface defInterface) throws InterfaceJaDeclaradaException {
		HashMap<Id, DefInterface> aux = pilhaDefInterfaces.peek();
		if (aux.put(idArg, defInterface) != null) {
			throw new InterfaceJaDeclaradaException(idArg);
		}
	}

}
