/* Arquivo AmbienteExecucaoICABS.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 15/04/08: Criação do arquivo
 * Carlos Eduardo Pontual - 20/04/08: Os métodos mapDefInterface e 
 * 		getDefInterface foram movidos de AmbienteExecucao.java para esta classe.
 */

package plp.interfaceclasseabstrata.memoria;

import java.util.Map;

import plp.imperative1.util.Lista;
import plp.interfaceclasseabstrata.declaracao.interfaces.ListaInterface;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos2.memoria.AmbienteExecucaoOO2;

public interface AmbienteExecucaoICABS extends AmbienteExecucaoOO2 {

	/**
	 * Mapeia um identificador a um definição de interface.
	 * 
	 * @param idArg
	 *            o nome da interface
	 * @param defInterface
	 *            Definição da Interface.
	 * @throws InterfaceJaDeclaradaException
	 *             quando a interface já foi declarada.
	 */
	public void mapDefInterface(Id idArg, DefInterface defInterface) throws InterfaceJaDeclaradaException;

	/**
	 * Obtém a definição da interface cujo nome é idArg
	 * 
	 * @param listaInterface
	 *            Uma lista com nomes de interfaces.
	 * @return Uma lista com as definições das inerfaces
	 * @throws InterfaceNaoDeclaradaException
	 *             quando nao foi declarada nenhuma interface com esse nome.
	 */
	public Lista<DefInterface> getDefInterface(ListaInterface listaInterface) throws InterfaceNaoDeclaradaException;

	/**
	 * Obtém a definição da interface cujo nome é idArg
	 * 
	 * @param idArg
	 *            Nome da interface.
	 * @return a definição da interface.
	 * @throws InterfaceNaoDeclaradaException
	 *             quando nao foi declarada nenhuma interface com esse nome.
	 */
	public DefInterface getDefInterface(Id idArg) throws InterfaceNaoDeclaradaException;

	/**
	 * Mapeia um identificador de classe com o identificador da interface que
	 * ela implementa.
	 * 
	 * @param classe
	 *            identificador da sub-classe
	 * @param superClasse
	 *            identificador da interface
	 * @throws InterfaceNaoDeclaradaException
	 *             Quando a interface não foi declarada
	 */
	public void mapImplementsInterface(Id classe, ListaInterface listaInterface);

	/**
	 * Dado um identificador da classe, recupera a interface que ela implementa
	 * 
	 * @param classe
	 *            identificador da classe base
	 * @return Definição da interface
	 * @throws InterfaceNaoDeclaradaException
	 *             Quando a classe ainda nao foi definida
	 */
	public Lista<DefInterface> getImplementsInterface(Id classe) throws InterfaceNaoDeclaradaException;

	public Map<Id, ListaInterface> getMapClasseInterface();

}
