/* Arquivo AmbienteCompilacaoICABS.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 15/04/08: Criação do arquivo
 * Carlos Eduardo Pontual - 20/04/08: Os métodos mapAssinaturas, getParametrosAssinaturas
 * 		mapDefInterface e getDefInterface foram movidos de AmbienteCompilacao.java para esta classe.
 */

package plp.interfaceclasseabstrata.memoria;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2;

public interface AmbienteCompilacaoICABS extends AmbienteCompilacaoOO2 {

	/**
	 * Mapeia um identificador representando uma assinatura e seus parâmetros.
	 * 
	 * @param idArg
	 *            identificador de assinatura.
	 * @param parametrosId
	 *            Parâmetros da assinatura
	 * @throws AssinaturaJaDeclaradaException
	 *             quando a assinatura já foi declarada.
	 */
	public void mapAssinaturas(Id idArg, ListaDeclaracaoParametro assinaturasId) throws AssinaturaJaDeclaradaException;

	/**
	 * Obtém a tail de parâmetros associada a um identificador que representa
	 * nome da assinatura
	 * 
	 * @param idArg
	 *            Identificador que representa o nome da assinatura.
	 * @return Lista de parâmetros associada a um identificador que representa
	 *         nome da assinatura.
	 * @throws AssinaturaNaoDeclaradaException
	 *             quando não foi declarada nenhuma assinatura com esse id.
	 */
	public ListaDeclaracaoParametro getParametrosAssinatura(Id idArg) throws AssinaturaNaoDeclaradaException;

	/**
	 * Mapeia um identificador a um definição de interface.
	 * 
	 * @param idArg
	 *            o nome da interface
	 * @param defInterface
	 *            Definição da Interface.
	 * @throws InterfaceJaDeclaradaException
	 *             quando a interface já foi declarada.
	 */
	public void mapDefInterface(Id idArg, DefInterface defInterface) throws InterfaceJaDeclaradaException;

	/**
	 * Obtém a definição da interface cujo nome é idArg
	 * 
	 * @param idArg
	 *            Nome da interface.
	 * @return a definição da interface.
	 * @throws InterfaceNaoDeclaradaException
	 *             quando nao foi declarada nenhuma interface com esse nome.
	 */
	public DefInterface getDefInterface(Id idArg) throws InterfaceNaoDeclaradaException;

	/**
	 * Mapeia um identificador de classe com o identificador da interface que
	 * ela implementa.
	 * 
	 * @param classe
	 *            identificador da sub-classe
	 * @param superClasse
	 *            identificador da interface
	 * @throws InterfaceNaoDeclaradaException
	 *             Quando a interface não foi declarada
	 */
	public void mapImplementsClasse(Id classe, Id idInterface) throws ClasseNaoDeclaradaException,
			InterfaceNaoDeclaradaException;

	/**
	 * Dado um identificador da classe, recupera a interface que ela implementa
	 * 
	 * @param classe
	 *            identificador da classe base
	 * @return Definição da interface
	 * @throws InterfaceNaoDeclaradaException
	 *             Quando a interface ainda não foi definida
	 */
	public DefInterface getImplementsClasse(Id classe) throws InterfaceNaoDeclaradaException;

}
