/* Arquivo ListaInterface.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 18/04/08: Criação do arquivo
 */

package plp.interfaceclasseabstrata.declaracao.interfaces;

import plp.imperative1.util.Lista;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.AmbienteCompilacaoICABS;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;

public class ListaInterface extends Lista<Id> {

	public ListaInterface() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * Construtor
	 * 
	 * @param declaracao
	 *            A declaração contida por esta tail.
	 */
	public ListaInterface(Id nomeInterface) {
		super(nomeInterface, null);
	}

	/**
	 * Construtor.
	 * 
	 * @param declaracao
	 *            A declaração contida por esta tail.
	 * @param listaDeclaracao
	 *            A tail de declarações que segue declaração.
	 */
	public ListaInterface(Id nomeInterface, ListaInterface listaInterface) {
		super(nomeInterface, listaInterface);
	}

	/**
	 * Verifica apenas se a interface referenciada na lista já foi declarada ou
	 * não
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> Se todas as interfaces da lista já foram
	 *         mapeadas <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws InterfaceNaoDeclaradaException {
		boolean resposta;
		if (getHead() != null) {
			if (getTail() != null) {
				resposta = (((AmbienteCompilacaoICABS) ambiente).getDefInterface(getHead().getId()) != null)
						&& ((ListaInterface) getTail()).checaTipo(ambiente);
			} else {
				resposta = (((AmbienteCompilacaoICABS) ambiente).getDefInterface(getHead().getId()) != null);
			}
		} else {
			resposta = true;
		}
		return resposta;
	}

	/**
	 * Insere um id de interface na última posição da lista de interfaces
	 * 
	 * @param O
	 *            Id da interface que deve ser adicionada na lista
	 * 
	 */

	public void insereFim(Id idInterface) {
		if (getHead() != null) {
			if (getTail() != null)
				((ListaInterface) getTail()).insereFim(idInterface);
			else {
				this.tail = new ListaInterface(idInterface, null);
			}
		} else
			this.head = idInterface;
	}

}