/* Arquivo DeclaracaoInterface.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 14/04/08: Criação do arquivo
 */

package plp.interfaceclasseabstrata.declaracao.interfaces;

import plp.interfaceclasseabstrata.assinatura.ListaAssinaturaMetodo;
import plp.interfaceclasseabstrata.declaracao.DeclaracaoSimples;
import plp.interfaceclasseabstrata.declaracao.RelacaoClasseInterface;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.AmbienteCompilacaoICABS;
import plp.interfaceclasseabstrata.memoria.AmbienteExecucaoICABS;
import plp.interfaceclasseabstrata.memoria.DefInterface;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos2.util.DefObjectFactory;

public class DeclaracaoInterface implements DeclaracaoSimples {

	/**
	 * Identificador do nome da interface e do nome da superclasse (interface).
	 */
	protected Id nomeInterface, nomeSuperInterface;
	/**
	 * Atributos da classe.
	 */
	protected ListaAssinaturaMetodo assinaturas;

	/**
	 * Construtor.
	 * 
	 * @param nomeInterface
	 *            Nome da interface
	 * @param nomeSuperInterface
	 *            Nome da superclasse
	 * @param assinaturas
	 *            Assinaduas de métodos da interface.
	 */
	public DeclaracaoInterface(Id nomeInterface, Id nomeSuperInterface, ListaAssinaturaMetodo assinaturas) {
		this.nomeInterface = nomeInterface;
		this.assinaturas = assinaturas;
		this.nomeSuperInterface = (nomeSuperInterface == null) ? null : nomeSuperInterface;
	}

	/**
	 * Cria um mapeamento do identificador para a declaração desta interface.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente modificado pela declaração da classe.
	 */
	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {

		((AmbienteExecucaoICABS) ambiente).mapDefInterface(nomeInterface, new DefInterface(nomeInterface,
				nomeSuperInterface, assinaturas));
		return ambiente;
	}

	/**
	 * Verifica se a declaração está bem tipada, ou seja, se a checagem dos
	 * tipos dos métodos e atributos está ok.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> se os tipos da declaração são válidos;
	 *         <code>false</code> caso contrário.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException,
			ClasseJaDeclaradaException {

		/*
		 * Verifica se o nome da interface já não é o nome de uma classe. Caso
		 * não seja, ok, podemos prosseguir. Caso seja, lançaremos uma exceção
		 * (em Java não podemos ter uma Classe e uma Interface com mesmo nome)
		 */
		try {
			DefClasse defClasse = ((AmbienteCompilacaoICABS) ambiente).getDefClasse(nomeInterface);
			if (defClasse != null) {
				throw new ClasseJaDeclaradaException(nomeInterface);
			}
		} catch (ClasseNaoDeclaradaException ex) {
		}

		if (nomeSuperInterface != null) {
			DefInterface superInterface = ((AmbienteCompilacaoICABS) ambiente).getDefInterface(nomeSuperInterface);
		}
		((AmbienteCompilacaoICABS) ambiente).mapDefInterface(nomeInterface, new DefInterface(nomeInterface,
				nomeSuperInterface, assinaturas));
		/* Relacionamento extendsImplements */
		// if (nomeSuperInterface != null)
		// RelacaoClasseInterface.getInstancia().map(nomeInterface,
		// nomeSuperInterface, RelacaoClasseInterface.INTERFACE);
		/* Fim do código de relacionamento extendsImplements */

		boolean resposta = false;
		ambiente.incrementa();
		// if (assinaturas.checaTipo(ambiente)){
		// ambiente.mapTipo(new Id("this"), new TipoClasse(nomeClasse));
		// resposta = metodos.checaTipo(ambiente);
		// }
		resposta = assinaturas.checaTipo(ambiente);
		ambiente.restaura();
		return resposta;
	}

	public Id getNomeInterface() {
		return nomeInterface;
	}

}
