/* Arquivo DeclaracaoClasse.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 14/04/08: Criação do arquivo
 */

package plp.interfaceclasseabstrata.declaracao.classes;

import plp.interfaceclasseabstrata.declaracao.DeclaracaoSimples;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimento;
import plp.orientadaObjetos1.declaracao.variavel.DecVariavel;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.util.TipoClasse;

/**
 * Classe que representa a declara��o de uma �nica classe.
 */
public class DeclaracaoClasse implements DeclaracaoSimples {
	/**
	 * Identificador do nome da classe.
	 */
	protected Id nomeClasse;
	/**
	 * Atributos da classe.
	 */
	protected DecVariavel atributos;
	/**
	 * M�todos da classe.
	 */
	protected DecProcedimento metodos;

	/**
	 * Construtor.
	 * 
	 * @param nomeClasse
	 *            Nome da classe
	 * @param atributos
	 *            Atributos da classe
	 * @param metodos
	 *            M�todos da classe.
	 */
	public DeclaracaoClasse(Id nomeClasse, DecVariavel atributos, DecProcedimento metodos) {
		this.nomeClasse = nomeClasse;
		this.atributos = atributos;
		this.metodos = metodos;
	}

	/**
	 * Cria um mapeamento do identificador para a declara��o desta classe.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente modificado pela declara��o da classe.
	 */
	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws ClasseJaDeclaradaException,
			ClasseNaoDeclaradaException {

		ambiente.mapDefClasse(nomeClasse, new DefClasse(nomeClasse, atributos, metodos));
		return ambiente;
	}

	/**
	 * Verifica se a declara��o est� bem tipada, ou seja, se a checagem dos
	 * tipos dos m�todos e atributos est� ok.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> se os tipos da declara��o s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {

		ambiente.mapDefClasse(nomeClasse, new DefClasse(nomeClasse, atributos, metodos));
		boolean resposta = false;
		ambiente.incrementa();
		if (atributos.checaTipo(ambiente)) {
			ambiente.mapTipo(new Id("this"), new TipoClasse(nomeClasse));
			resposta = metodos.checaTipo(ambiente);
		}
		ambiente.restaura();
		return resposta;
	}

}