/* Arquivo DefClasseSimplesICABS.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 15/04/08: Criação da classe.
 */

package plp.interfaceclasseabstrata.declaracao.classes;

import plp.interfaceclasseabstrata.declaracao.interfaces.ListaInterface;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.AmbienteCompilacaoICABS;
import plp.interfaceclasseabstrata.memoria.DefInterface;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimento;
import plp.orientadaObjetos1.declaracao.variavel.DecVariavel;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos2.declaracao.classe.DecClasseSimplesOO2;

public abstract class DecClasseICABS extends DecClasseSimplesOO2 {

	protected ListaInterface listaInterface;

	public DecClasseICABS(Id nomeClasse, Id superClasse, ListaInterface interfaces, DecVariavel atributos,
			DecProcedimento metodos) {
		super(nomeClasse, superClasse, atributos, metodos);
		this.listaInterface = interfaces;
	}

	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {

		/*
		 * Verifica se o nome da classe já não é o nome de uma interface. Caso
		 * não seja, ok, podemos prosseguir. Caso seja, lançaremos uma exceção
		 * (em Java não podemos ter uma Classe e uma Interface com mesmo nome)
		 */
		try {
			DefInterface defInterface = ((AmbienteCompilacaoICABS) ambiente).getDefInterface(nomeClasse);
			if (defInterface != null) {
				throw new InterfaceJaDeclaradaException(nomeClasse);
			}
		} catch (InterfaceNaoDeclaradaException ex) {
		}

		return super.checaTipo(ambiente);
	}

	public abstract AmbienteExecucao elabora(AmbienteExecucao ambiente) throws ClasseJaDeclaradaException,
			ClasseNaoDeclaradaException;

	public ListaInterface getListaInterface() {
		return listaInterface;
	}

}
