package plp.interfaceclasseabstrata.declaracao.classes;

import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

import plp.imperative1.util.Lista;
import plp.interfaceclasseabstrata.assinatura.AssinaturaMetodo;
import plp.interfaceclasseabstrata.assinatura.ListaAssinaturaMetodo;
import plp.interfaceclasseabstrata.declaracao.RelacaoClasseInterface;
import plp.interfaceclasseabstrata.declaracao.interfaces.ListaInterface;
import plp.interfaceclasseabstrata.declaracao.procedimentos.DecProcedimentoAbstrato;
import plp.interfaceclasseabstrata.declaracao.procedimentos.DecProcedimentoConcreto;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.AmbienteCompilacaoICABS;
import plp.interfaceclasseabstrata.memoria.AmbienteExecucaoICABS;
import plp.interfaceclasseabstrata.memoria.DefClasseAbstrata;
import plp.interfaceclasseabstrata.memoria.DefClasseConcreta;
import plp.interfaceclasseabstrata.memoria.DefInterface;
import plp.orientadaObjetos1.comando.Procedimento;
import plp.orientadaObjetos1.declaracao.procedimento.DecParametro;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimento;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimentoComposta;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimentoSimples;
import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.declaracao.variavel.CompostaDecVariavel;
import plp.orientadaObjetos1.declaracao.variavel.DecVariavel;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.Ambiente;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.util.ListaTipo;
import plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2;
import plp.orientadaObjetos2.memoria.AmbienteExecucaoOO2;
import plp.orientadaObjetos2.util.DefObjectFactory;

public class DecClasseConcreta extends DecClasseICABS {

	public DecClasseConcreta(Id nomeClasse, Id superClasse, ListaInterface interfaces, DecVariavel atributos,
			DecProcedimento metodos) {
		super(nomeClasse, superClasse, interfaces, atributos, metodos);
		// TODO Auto-generated constructor stub
	}

	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {

		// Checa tipo adicionado para classes abstratas

		if (superClasse.equals(DefObjectFactory.OBJECT_ID)) {
			DefObjectFactory.createObject(ambiente);
		}

		DefClasse defSuperClasse = ((AmbienteCompilacaoOO2) ambiente).getDefClasse(this.superClasse);
		if (defSuperClasse instanceof DefClasseAbstrata) {
			Stack<Id> pais = new Stack<Id>();
			HashMap<Id, Vector<DecProcedimentoSimples>> mapProcAbstratos = new HashMap<Id, Vector<DecProcedimentoSimples>>();

			Lista<DecProcedimentoSimples> procsAbstratos;
			Lista<DecProcedimentoSimples> procsConcretos;

			pais = retornaPaisAbstratos(defSuperClasse, ambiente);
			Id idClassePai = pais.pop();
			while (!(idClassePai.equals(DefObjectFactory.OBJECT_ID))) {

				defSuperClasse = ((AmbienteCompilacaoOO2) ambiente).getDefClasse(idClassePai);
				procsAbstratos = getMetodosAbstratos(defSuperClasse.getMetodos());
				procsConcretos = getMetodosConcretos(defSuperClasse.getMetodos());

				if (procsConcretos != null) {
					DecProcedimentoSimples decProcConcreto;
					while (procsConcretos != null) {
						decProcConcreto = procsConcretos.getHead();
						// procura no hashmap se ja tem algum metodo abstrato
						// com o mesmo nome
						Vector<DecProcedimentoSimples> vectDec = mapProcAbstratos.get(decProcConcreto.getNome());
						if (vectDec != null) {
							// verificar se parametros formais casam
							Vector<DecProcedimentoSimples> copiaVectDec = (Vector<DecProcedimentoSimples>) vectDec
									.clone();
							for (DecProcedimentoSimples dec : vectDec)
								if (decProcConcreto.getParametrosFormais().equals(dec.getParametrosFormais())) {
									copiaVectDec.remove(dec);
								}
							if (copiaVectDec.size() > 0)
								mapProcAbstratos.put(decProcConcreto.getNome(), copiaVectDec);
							else
								mapProcAbstratos.remove(decProcConcreto.getNome());
						}
						procsConcretos = procsConcretos.getTail();
					}
				}

				if (procsAbstratos != null) {
					DecProcedimentoSimples decProcAbstrato;
					while (procsAbstratos != null) {
						decProcAbstrato = procsAbstratos.getHead();
						Vector<DecProcedimentoSimples> vectDec;
						if ((vectDec = mapProcAbstratos.get(decProcAbstrato.getNome())) == null)
							vectDec = new Vector<DecProcedimentoSimples>();
						vectDec.add(decProcAbstrato);
						mapProcAbstratos.put(decProcAbstrato.getNome(), vectDec);
						procsAbstratos = procsAbstratos.getTail();
					}
				}

				if (!pais.empty()) {
					idClassePai = pais.pop();
				} else {
					idClassePai = DefObjectFactory.OBJECT_ID;
				}
			}
			// verificar se os metodos abstratos estao sendo implementados
			for (Id idMetodoAbstrato : mapProcAbstratos.keySet()) {
				// Procura por algum metodo na classe que tenha o mesmo nome do
				// metodo abstrato
				Vector<DecProcedimentoSimples> vectDec = mapProcAbstratos.get(idMetodoAbstrato);

				for (DecProcedimentoSimples dec : vectDec) {
					ListaTipo lt = getTipos(ambiente, dec.getParametrosFormais());
					Procedimento proc = metodos.getProcedimento(idMetodoAbstrato, lt);
					if (proc == null) {
						System.out.println("parametros formais nao casaram");
						return false;
					}
				}
			}
		}
		if (listaInterface == null) {
			return super.checaTipo(ambiente);
		}

		// Devo verificar se o nome da interface é valido
		// Devo verificar se os métodos implementam todas as assinaturas das
		// interfaces
		DefInterface defInteface;
		ListaAssinaturaMetodo listaAssinaturas;

		AssinaturaMetodo ass = null;

		ListaInterface interfaces = listaInterface;

		Id superInterface;

		/*
		 * Verifica se a lista de interfaces não é nula Caso ela não seja,
		 * verifica se o tamanho dela é maior do que um (se for, a super
		 * interface não é Object). Caso seja um, temos o caso onde ela é apenas
		 * uma
		 */
		while (interfaces != null) {
			superInterface = interfaces.getHead().getId();
			while (superInterface != null) {
				defInteface = ((AmbienteCompilacaoICABS) ambiente).getDefInterface(superInterface);
				listaAssinaturas = defInteface.assinaturas();
				// Percorre a lista de assinaturas
				while ((listaAssinaturas != null) && ((ass = listaAssinaturas.getHead()) != null)) {
					// Procura um procedimento na classe que tem o mesmo nome do
					// procedimento da interface
					Procedimento proc = metodos.getProcedimento(ass.getId(), getTipos(ambiente, ass
							.getParametrosFormais()));
					// Verifica se a lista de parametros formais é a mesma da
					// assinatura
					if (!ass.getParametrosFormais().equals(proc.getParametrosFormais()))
						return false;
					listaAssinaturas = (ListaAssinaturaMetodo) listaAssinaturas.getTail();
				}
				superInterface = defInteface.getSuperInterface();
			}
			/* Relacionamento extendsImplements */
			RelacaoClasseInterface.getInstancia().map(nomeClasse, interfaces.getHead().getId(),
					RelacaoClasseInterface.INTERFACE);
			/* Fim do código de relacionamento extendsImplements */
			interfaces = (ListaInterface) interfaces.getTail();
		}

		return super.checaTipo(ambiente);

	}

	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws ClasseJaDeclaradaException,
			ClasseNaoDeclaradaException {

		if (superClasse.equals(DefObjectFactory.OBJECT_ID)) {
			// TODO Rever esse metodo createObject
			DefObjectFactory.createObject(ambiente);
		}

		DefClasse defSuperClasse = ((AmbienteExecucaoOO2) ambiente).getDefClasse(this.superClasse);
		DecVariavel atributosHerdados = defSuperClasse.getDecVariavel();

		ambiente.mapDefClasse(nomeClasse, new DefClasseConcreta(nomeClasse, new CompostaDecVariavel(atributos,
				atributosHerdados), metodos));
		((AmbienteExecucaoOO2) ambiente).mapSuperClasse(nomeClasse, superClasse);
		((AmbienteExecucaoICABS) ambiente).mapImplementsInterface(nomeClasse, listaInterface);
		return ambiente;
	}

	public Lista<DecProcedimentoSimples> getMetodosAbstratos(DecProcedimento dec) {
		if (dec instanceof DecProcedimentoComposta) {
			DecProcedimento dec1 = ((DecProcedimentoComposta) dec).getDeclaracao1();
			DecProcedimento dec2 = ((DecProcedimentoComposta) dec).getDeclaracao2();
			if (dec1 instanceof DecProcedimentoAbstrato) {
				return new Lista<DecProcedimentoSimples>((DecProcedimentoAbstrato) dec1, getMetodosAbstratos(dec2));
			}
			return getMetodosAbstratos(dec2);

		} else if (dec instanceof DecProcedimentoAbstrato) {
			return new Lista<DecProcedimentoSimples>((DecProcedimentoAbstrato) dec, null);
		}

		return null;
	}

	public Lista<DecProcedimentoSimples> getMetodosConcretos(DecProcedimento dec) {
		if (dec instanceof DecProcedimentoComposta) {
			DecProcedimento dec1 = ((DecProcedimentoComposta) dec).getDeclaracao1();
			DecProcedimento dec2 = ((DecProcedimentoComposta) dec).getDeclaracao2();
			if (dec1 instanceof DecProcedimentoConcreto) {
				return new Lista<DecProcedimentoSimples>((DecProcedimentoConcreto) dec1, getMetodosConcretos(dec2));
			}
			return getMetodosConcretos(dec2);

		} else if (dec instanceof DecProcedimentoConcreto) {

			return new Lista<DecProcedimentoSimples>((DecProcedimentoConcreto) dec, null);
		}

		return null;
	}

	public static ListaTipo getTipos(Ambiente ambiente, ListaDeclaracaoParametro parametros) {
		ListaDeclaracaoParametro l = parametros;
		Stack<DecParametro> pilhaParametro = new Stack<DecParametro>();
		while ((l != null) && (l.getHead() != null)) {
			pilhaParametro.push(l.getHead());
			l = (ListaDeclaracaoParametro) l.getTail();
		}
		ListaTipo lt = new ListaTipo();
		while (!pilhaParametro.isEmpty()) {
			DecParametro dp = pilhaParametro.pop();
			lt = new ListaTipo(dp.getTipo(), lt);
		}
		return lt;
	}

	public Stack<Id> retornaPaisAbstratos(DefClasse defClassePai, AmbienteCompilacao ambiente)
			throws ClasseNaoDeclaradaException {
		Stack<Id> pais = new Stack<Id>();
		while (!(defClassePai.getIdClasse().equals(DefObjectFactory.OBJECT_ID))) {
			if (defClassePai instanceof DefClasseAbstrata) {
				pais.push(defClassePai.getIdClasse());
				defClassePai = ((AmbienteCompilacaoOO2) ambiente).getSuperClasse(defClassePai.getIdClasse());
				continue;
			}
			break;
		}
		return pais;
	}

}
