package plp.interfaceclasseabstrata.declaracao.classes;

import plp.interfaceclasseabstrata.declaracao.interfaces.ListaInterface;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.DefClasseAbstrata;
import plp.interfaceclasseabstrata.memoria.DefClasseConcreta;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimento;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimentoComposta;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimentoSimples;
import plp.orientadaObjetos1.declaracao.variavel.CompostaDecVariavel;
import plp.orientadaObjetos1.declaracao.variavel.DecVariavel;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2;
import plp.orientadaObjetos2.memoria.AmbienteExecucaoOO2;
import plp.orientadaObjetos2.util.DefObjectFactory;

public class DecClasseAbstrata extends DecClasseICABS {

	public DecClasseAbstrata(Id nomeClasse, Id superClasse, ListaInterface interfaces, DecVariavel atributos,
			DecProcedimento metodos) {
		super(nomeClasse, superClasse, interfaces, atributos, metodos);
		// TODO Auto-generated constructor stub
	}

	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {
		// se nao estender nenhuma outra classe abstrata
		// verificar se nao tem nenhum metodo abstrato
		if (superClasse.equals(DefObjectFactory.OBJECT_ID)) {
			if (!temMetodoAbstrato(metodos)) {
				System.out.println("Clase " + nomeClasse + " nao define nenhum metodo abstrato");
				return false;

			}
		} else {
			DefClasse defSuperClasse = ((AmbienteCompilacaoOO2) ambiente).getDefClasse(this.superClasse);
			if (defSuperClasse instanceof DefClasseConcreta) {
				if (!temMetodoAbstrato(metodos)) {
					System.out.println("Clase " + nomeClasse + " nao define nenhum metodo abstrato");
					return false;
				}
			}
		}
		return super.checaTipo(ambiente);
	}

	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws ClasseJaDeclaradaException,
			ClasseNaoDeclaradaException {

		if (superClasse.equals(DefObjectFactory.OBJECT_ID)) {
			DefObjectFactory.createObject(ambiente);
		}
		DefClasse defSuperClasse = ((AmbienteExecucaoOO2) ambiente).getDefClasse(this.superClasse);
		DecVariavel atributosHerdados = defSuperClasse.getDecVariavel();
		ambiente.mapDefClasse(nomeClasse, new DefClasseAbstrata(nomeClasse, new CompostaDecVariavel(atributos,
				atributosHerdados), metodos));
		((AmbienteExecucaoOO2) ambiente).mapSuperClasse(nomeClasse, superClasse);
		return ambiente;
	}

	public boolean temMetodoAbstrato(DecProcedimento dec) {
		if (dec instanceof DecProcedimentoComposta) {
			return temMetodoAbstrato(((DecProcedimentoComposta) dec).getDeclaracao1())
					|| temMetodoAbstrato(((DecProcedimentoComposta) dec).getDeclaracao2());
		} else if (dec instanceof DecProcedimentoSimples) {
			if (((DecProcedimentoSimples) dec).getComando() == null) {
				return true;
			}
		}
		return false;
	}
}
