package plp.interfaceclasseabstrata.declaracao;

import java.util.HashMap;
import java.util.LinkedHashSet;

import plp.orientadaObjetos1.expressao.leftExpression.Id;

public class RelacaoClasseInterface {

	public static int CLASS = 1;

	public static int INTERFACE = 2;

	public static int ANY = 3;

	private static RelacaoClasseInterface relacaoClasseInterface;

	private HashMap<Id, LinkedHashSet<IdTipo>> hashExtendsImplements;

	public static RelacaoClasseInterface getInstancia() {
		if (relacaoClasseInterface == null)
			relacaoClasseInterface = new RelacaoClasseInterface();
		return relacaoClasseInterface;
	}

	private RelacaoClasseInterface() {
		if (hashExtendsImplements == null)
			hashExtendsImplements = new HashMap<Id, LinkedHashSet<IdTipo>>();
	}

	public HashMap<Id, IdTipo> getFechoHash(Id id, int tipo) {
		if (hashExtendsImplements.get(id) == null)
			return null;
		LinkedHashSet<IdTipo> fecho = fecho(hashExtendsImplements.get(id), tipo);
		HashMap<Id, IdTipo> retorno = new HashMap<Id, IdTipo>();
		for (IdTipo declaracao : fecho) {
			retorno.put(declaracao.getId(), declaracao);
		}

		return retorno;
	}

	public boolean map(Id idOrigem, Id idDestino, int tipo) {
		LinkedHashSet<IdTipo> lista = hashExtendsImplements.get(idOrigem);
		if (lista == null)
			lista = new LinkedHashSet<IdTipo>();
		boolean res = lista.add(new IdTipo(idDestino, tipo));
		hashExtendsImplements.put(idOrigem, lista);

		return res;
	}

	public LinkedHashSet<IdTipo> getFechoSet(Id id, int tipo) {
		if (hashExtendsImplements.get(id) == null)
			return null;
		return fecho(hashExtendsImplements.get(id), tipo);
	}

	private LinkedHashSet<IdTipo> fecho(LinkedHashSet<IdTipo> relacao, int tipo) {
		LinkedHashSet<IdTipo> retorno = null;
		if (tipo == ANY) {
			retorno = (LinkedHashSet<IdTipo>) relacao.clone();
		} else {
			retorno = new LinkedHashSet<IdTipo>();
			for (IdTipo declaracao : relacao) {
				if (declaracao.getTipo() == tipo)
					retorno.add(declaracao);
			}
		}

		for (IdTipo declaracao : relacao) {
			if ((tipo == ANY) || (declaracao.getTipo() == tipo)) {
				if (declaracao.getId() != null) {
					LinkedHashSet<IdTipo> prox = hashExtendsImplements.get(declaracao.getId());
					if (prox != null)
						retorno.addAll(fecho(prox, tipo));
				}
			}
			/*
			 * if ((declaracao.getTipo() == INTERFACE) && ((tipo == INTERFACE) ||
			 * (tipo == ANY))) { id = declaracao.getId(); } else if ((declaracao
			 * instanceof DeclaracaoClasse) && ((tipo == CLASS) || (tipo ==
			 * ANY))) { id = ((DeclaracaoClasse) declaracao).getNomeClasse(); }
			 * if ((id != null) && (hashExtendsImplements.get(id) != null))
			 * retorno.addAll(fecho(hashExtendsImplements.get(id), tipo));
			 */
		}
		return retorno;
	}

	public class IdTipo {
		private Id id;

		private int tipo;

		public IdTipo(Id id, int tipo) {
			this.id = id;
			this.tipo = tipo;
		}

		public Id getId() {
			return id;
		}

		public int getTipo() {
			return tipo;
		}

		public String toString() {
			return (id == null) ? "Nulo" : id.toString() + " , " + tipo + " .";
		}
	}

}
