/* Arquivo DeclaracaoComposta.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 14/04/08: Criação da classe
 */

package plp.interfaceclasseabstrata.declaracao;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;

public class DeclaracaoComposta implements Declaracao {

	private Declaracao d1, d2;

	public DeclaracaoComposta(Declaracao d1, Declaracao d2) {
		this.d1 = d1;
		this.d2 = d2;
	}

	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoJaDeclaradoException, ProcedimentoNaoDeclaradoException,
			ClasseJaDeclaradaException, ClasseNaoDeclaradaException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {
		// TODO Auto-generated method stub
		return d1.checaTipo(ambiente) && d2.checaTipo(ambiente);
	}

	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoJaDeclaradoException, ProcedimentoNaoDeclaradoException,
			ClasseJaDeclaradaException, ClasseNaoDeclaradaException, ObjetoNaoDeclaradoException,
			ObjetoJaDeclaradoException, InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException,
			AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {
		// TODO Auto-generated method stub
		return d2.elabora(d1.elabora(ambiente));
	}

}
