/* Arquivo ListaAssinaturaMetodo.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 14/04/08: Criação do arquivo
 */

package plp.interfaceclasseabstrata.assinatura;

import plp.imperative1.util.Lista;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;

public class ListaAssinaturaMetodo extends Lista<AssinaturaMetodo> {

	public ListaAssinaturaMetodo() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * Construtor
	 * 
	 * @param declaracao
	 *            A declara��o contida por esta tail.
	 */
	public ListaAssinaturaMetodo(AssinaturaMetodo assinatura) {
		super(assinatura, null);
	}

	/**
	 * Construtor.
	 * 
	 * @param declaracao
	 *            A declara��o contida por esta tail.
	 * @param listaDeclaracao
	 *            A tail de declara��es que segue declara��o.
	 */
	public ListaAssinaturaMetodo(AssinaturaMetodo assinatura, ListaAssinaturaMetodo listaAssinatura) {
		super(assinatura, listaAssinatura);
	}

	/**
	 * Verifica se a declaração head e a tail de declaração estão bem tipadas,
	 * ou seja, se a expressão de inicialização está bem tipada.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> se os tipos da declaração são válidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) {
		boolean resposta;
		if (getHead() != null) {
			if (getTail() != null) {
				resposta = getHead().checaTipo(ambiente) && ((ListaAssinaturaMetodo) getTail()).checaTipo(ambiente);
			} else {
				resposta = getHead().checaTipo(ambiente);
			}
		} else {
			resposta = true;
		}
		return resposta;
	}

	/**
	 * Cria um mapeamento do identificador para o tipo do parametro desta
	 * declaração no AmbienteCompilacao
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificador e seu
	 *            tipo.
	 * @return o ambiente modificado pela declaração do parametro.
	 */
	public AmbienteCompilacao declaraParametro(AmbienteCompilacao ambiente) throws AssinaturaNaoDeclaradaException,
			AssinaturaJaDeclaradaException {

		AmbienteCompilacao resposta;
		if (getHead() != null) {
			if (getTail() != null) {
				resposta = ((ListaAssinaturaMetodo) getTail()).declaraParametro(getHead().declaraParametro(ambiente));
			} else {
				resposta = getHead().declaraParametro(ambiente);
			}
		} else {
			resposta = ambiente;
		}
		return resposta;
	}
}
