/* Arquivo AssinaturaMetodo.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 14/04/08: Criação do arquivo
 */

package plp.interfaceclasseabstrata.assinatura;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.AmbienteCompilacaoICABS;
import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;

/*
 * Se for necessário retornar um procedimento, o que eu acho muito dificil,
 * devemos extender DecProcedimento.
 * 
 */
public class AssinaturaMetodo {

	private String modificador;

	private Id nome;

	private ListaDeclaracaoParametro parametrosFormais;

	public AssinaturaMetodo(Id nome, ListaDeclaracaoParametro parametrosFormais, String modificador) {
		this.modificador = modificador;
		this.parametrosFormais = parametrosFormais;
		this.nome = nome;
	}

	// Precisa do checaTipo? Não sei. Precisa, para verificar se ela eh true.

	public boolean checaTipo(AmbienteCompilacao ambiente) {
		return !modificador.equalsIgnoreCase("private");
	}

	public AssinaturaMetodo getAssinatura(Id nomeAssinatura) throws AssinaturaNaoDeclaradaException {
		if (this.nome.equals(nome)) {
			return this;
		} else {
			throw new AssinaturaNaoDeclaradaException(nome);
		}
	}

	public Id getId() {
		return this.nome;
	}

	public String getModificador() {
		return this.modificador;
	}

	public ListaDeclaracaoParametro getParametrosFormais() {
		return parametrosFormais;
	}

	public AmbienteCompilacao declaraParametro(AmbienteCompilacao ambiente) throws AssinaturaJaDeclaradaException,
			AssinaturaNaoDeclaradaException {

		((AmbienteCompilacaoICABS) ambiente).mapAssinaturas(nome, parametrosFormais);
		return ambiente;
	}

}
