/* Arquivo Programa.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Criação da classe Programa
 * 
 */

package plp.interfaceclasseabstrata;

import plp.interfaceclasseabstrata.declaracao.Declaracao;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.comando.Comando;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.execucao.EntradaInvalidaException;
import plp.orientadaObjetos1.excecao.execucao.EntradaNaoFornecidaException;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;

/**
 * Classe que representa um programa na linguagem OO-interfaceclasseabstrata.
 */
public class Programa {

	/**
	 * Declarações de classes e interfaces
	 */
	private Declaracao declaracoes;

	private Comando comando;

	/**
	 * Construtor.
	 * 
	 * @param decClasse
	 *            A declaração de classe(s)
	 * @param comando
	 *            O comando executado após a declaração.
	 */
	public Programa(Declaracao declaracoes, Comando comando) {
		this.declaracoes = declaracoes;
		this.comando = comando;
	}

	/**
	 * Executa o programa.
	 * 
	 * @param ambiente
	 *            o ambiente de execução.
	 * @return o ambiente depois de modificado pela execução do programa.
	 * @exception EntradaNaoFornecidaException
	 *                se não for fornecida a tail de valores de entrada do
	 *                programa.
	 */
	public ListaValor executar(AmbienteExecucao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ObjetoNaoDeclaradoException, ObjetoJaDeclaradoException,
			ProcedimentoJaDeclaradoException, ProcedimentoNaoDeclaradoException, ClasseJaDeclaradaException,
			ClasseNaoDeclaradaException, EntradaNaoFornecidaException, EntradaInvalidaException,
			InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException,
			AssinaturaNaoDeclaradaException {

		if (ambiente == null)
			throw new EntradaNaoFornecidaException();

		ambiente.incrementa();
		if (declaracoes == null)
			ambiente = comando.executar(ambiente);
		else
			ambiente = comando.executar(declaracoes.elabora(ambiente));
		ambiente.restaura();

		return ambiente.getSaida();
	}

	/**
	 * Realiza a verificação de tipos do programa
	 * 
	 * @param ambiente
	 *            o ambiente de compilação.
	 * @return <code>true</code> se o programa está bem tipado;
	 *         <code>false</code> caso contrario.
	 * @exception EntradaNaoFornecidaException
	 *                se não for fornecida a tail de valores de entrada do
	 *                programa.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
			ClasseJaDeclaradaException, ClasseNaoDeclaradaException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException,
			EntradaNaoFornecidaException {

		boolean resposta;

		if (ambiente == null) {
			throw new EntradaNaoFornecidaException();
		}
		ambiente.incrementa();
		if (declaracoes == null)
			resposta = comando.checaTipo(ambiente);
		else
			resposta = declaracoes.checaTipo(ambiente) && comando.checaTipo(ambiente);
		ambiente.restaura();

		return resposta;
	}
}