/*
 * ExpOrdem.java
 * 
 * Criacao da classe ExpOrdem
 */

package plp.expressions1.expression;

import plp.expressions1.util.Tipo;

/**
 * Classe que representa uma expressao unaria que retorna o codigo ASCII de um
 * caracter.
 * 
 * @author rbonifacio
 */
public class ExpOrdem extends ExpUnaria {

	/**
	 * Constroi uma expressao ordem, que retorna o codigo ASCII de um caracter
	 * 
	 * @param exp
	 *            Caracter a ter o codigo retornado. Assume-se que a avaliacao
	 *            resulte em <code>ValorCaracter</code>.
	 */
	public ExpOrdem(Expressao exp) {
		super(exp, "ordem");
	}

	/**
	 * Realiza a verificacao de tipos desta expressao.
	 * 
	 * @return <code>true</code> se os tipos da expressao sao validos;
	 *         <code>false</code> caso contrario.
	 */
	@Override
	protected boolean checaTipoElementoTerminal() {
		return getExp().getTipo().eCaracter();
	}

	/**
	 * Retorna um valor inteiro correspondendo ao codigo ASCII do caracter.
	 */
	public Valor avaliar() {
		int ascii = ((ValorCharacter) getExp().avaliar()).valor().charValue();

		return new ValorInteiro(ascii);
	}

	/**
	 * Retorna o tipo da expressao unaria que corresponde a ordem ASCII do
	 * caracter,
	 * 
	 * @return Inteiro correspondendo ao codigo ASCII do caracter
	 */
	public Tipo getTipo() {
		return Tipo.TIPO_INTEIRO;
	}

}
