#!/usr/bin/env perl

################################################################################
#
# Create a PythonFile containing all the gifs passed on the command line
# as base64-encrypted strings. The name of the strings are the basename
# of the gif-file.
#
#
use File::Basename;


$header = '################################################################################
#
#       This file is part of GQL
#
#	file:   GQLIcons.py
#
#       NOTE:   Automatically created by mkGQLIcons.pl
#               Do *not* edit this file manually
#
#       Copyright (C) 2003-2004 Alexander Schliep
#
#       Contact: schliep@molgen.mpg.de
#
#       Information: http://algorithmics.molgen.mpg.de/ghmm/gql.html
#
#	GQL is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	GQL is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with GQL; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#
#
################################################################################
';

$outfile = "GQLIcons.py";
$base64  = "./convert2base64.py";

print "# --------- mkGQLIcons.pl - creating $outfile\n";
open(FILE,">$outfile") || warn "Cannot open file $outfile!\n";

print FILE $header;

$init = 'def Init():
    import GQLGui
    imageCache = GQLGui.ImageCache() # singleton
';

foreach $file (@ARGV) {

  print "# working on $file\n";
  ($name, $path, $suffix) = fileparse($file, '\.gif');

  print FILE "$name = \"\"\"\n";
  print FILE `$base64 $file`;
  print FILE "\"\"\"\n\n";
  $init = $init . "    imageCache.AddImage(\"Icons/$name.gif\",$name)\n";
}

print FILE "$init\n";
