#!/usr/bin/env python2.3
################################################################################
#
#       This file is part of the GQL (Graphical Query Language) Toolkit
#
#       file:   GQLQuery.py
#       author: Ivan Costa (filho@molgen.mpg.de)
#
#       Copyright (C) 2003-2004 Alexander Schliep and Ivan Costa
#
#       Contact: filho@molgen.mpg.de
#
#       Information: http://ghmm.org/gql
#
#   GQL is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   GQL is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with GQL; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#
#       This file is version $Revision: 1.32 $
#                       from $Date: 2004/12/02 12:57:27 $
#             last change by $Author: filho $.
#
################################################################################

# Graph is a part of Gato which could be installed as a module
try:
    import Graph
except ImportError:
    import Gato.Graph as Graph
from numpy.oldnumeric import *

class PPIGraph(Graph.Graph):


    proteins = {} # genes presented in this GRAPH
    baitTargets = {} # bait -> proteins 

    def __init__(self):
        Graph.__init__(self)
        self.directed = 1
        self.proteins= {}
        self.baitTargets = {}

    
    def addProtein(self,name):
        id = self.AddVertex()
        self.proteins[name] = id

    def addInteraction(self,bait,target):
        # this is not working ? does gato acepts cyclic graphs?   
        #self.AddEdge(self.proteins[bait],self.proteins[target])
        return
    
    def loadPPIFromFile(self,fileName):
        ''' loads PPI interactions from a tab delimited file '''
        file = open(fileName,'r')
        lines = file.readlines()
        file.close()

        #print lines

        bait = None
        list = None

        for l in lines:
            l = l.strip('\n\c')
            header = l.split(' ')[0]
            #print l[len(header)+1:]
            items = l[len(header)+1:].split(';')

            bait = items[0]
            if (bait not in self.proteins):
                self.addProtein(bait)
                
            if len(items) > 1:
               tproteins = items[1].split(' ')

               for p in tproteins:
                 if (p not in self.proteins):
                    self.addProtein(p)
                 
                 self.addInteraction(bait,p)
               self.baitTargets[bait] = tproteins
               

    def loadPPIFromTabFile(self,fileName):
        ''' loads PPI interactions from a tab delimited file '''
        file = open(fileName,'r')
        lines = file.readlines()
        file.close()

        bait = None
        list = None

        for l in lines:
            l = l.strip('\n\c')
            genes = l.split('\t')
            head = genes[0]
            #print l[len(header)+1:]
            #items = l[len(header)+1:].split(';')

            bait = genes[0]
            if (bait not in self.proteins):
              self.addProtein(bait)                
            for p in genes[1:-1]:
              if (p not in self.proteins):
                self.addProtein(p)                 
              self.addInteraction(bait,p)
            self.baitTargets[bait] = genes[1:-1]

if __name__ == '__main__':
    
    import sys

    fileName = sys.argv[1]    
    
    ppi = PPIGraph()
    ppi.loadPPIFromTabFile(fileName)

    print ppi.proteins
    print ppi.baitTargets
    
    print len(ppi.proteins)
    count = 0
    for i in ppi.baitTargets.values():
        count = count + len(i)
    print count, count/float(len(ppi.proteins))
