#!/usr/bin/env python2.3
################################################################################
#
#       This file is part of the GQL (Graphical Query Language) Toolkit
#
#       file:   GQLGui.py
#       author: Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 2003-2004 Alexander Schliep
#
#       Contact: alexander@schliep.org
#
#       Information: http://ghmm.org/gql
#
#	GQL is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	GQL is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with GQL; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#
#       This file is version $Revision: 550 $
#                       from $Date: 2004-12-17 11:38:20 -0300 (Fri, 17 Dec 2004) $
#             last change by $Author: filho $.
#
################################################################################
#
#
#
#----- Globals -----------------------------------------------------------------
gGQLVersion = 1.0
gGQLBuilddate = "15/12/2004"
gNCBIURL = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=search&db=nucleotide&term=%s"
#-------------------------------------------------------------------------------
from Tkinter import *
import tkFont
from tkFileDialog import askopenfilename, asksaveasfilename
from tkMessageBox import askokcancel, showerror, askyesno
import tkSimpleDialog
#from ScrolledText import *
import os
import string
import colorsys
from GQLQuery import GQLQuery
from GQLQueryEditor import GQLQueryEditor
from ghmm import SequenceSet, Float


MISSING_DATA = -9999.99

################################################################################
#
# Tkinter Stuff
#
#


def WMExtrasGeometry(window):
    """ Returns (top,else) where
        - top is the amount of extra pixels the WM puts on top
          of the window
        - else is the amount of extra pixels the WM puts everywhere
          else around the window

        NOTE: Does not work with tk8.0 style menus, since those are
              handled by WM (according to Tk8.1 docs) """
    g = string.split(window.geometry(),"+")
    trueRootx = string.atoi(g[1])
    trueRooty = string.atoi(g[2])

    rootx = window.winfo_rootx() # top left of our window
    rooty = window.winfo_rooty() # *WITHOUT* WM extras
    topWMExtra = abs(rooty - trueRooty) # WM adds that on top
    WMExtra    = abs(rootx - trueRootx) # and that on all other sides
    return (topWMExtra,WMExtra)


class ImageCache:
    """ Provides a global cache for PhotoImages displayed in the
        application. Singleton Pattern """

    images = None

    def __init__(self):
        if ImageCache.images == None:
            ImageCache.images = {}

    def __getitem__(self, relURL):
        """ Given a relative URL to an image file return the
            corresponding PhotoImage. """
        try:
            if relURL not in self.images.keys():
                ImageCache.images[relURL] = PhotoImage(file=relURL)
            return ImageCache.images[relURL]
        except IndexError, IOError:
            #import logging
            #log = logging.getLogger("GatoUtil.py")
            #log.exception("Error finding image %s" % relURL)
            print "Error finding image %s" % relURL

    def AddImage(self, relURL, imageData):
        ImageCache.images[relURL] = PhotoImage(data=imageData)

class AboutBox(tkSimpleDialog.Dialog):
    """ The application's about box """
 
    def buttonbox(self):
        # Stolen from tkSimpleDialog.py
        # add standard button box. override if you don't want the
        # standard buttons
        box = Frame(self)
        w = Button(box, text="OK", width=10, command=self.ok, default=ACTIVE)
        w.pack(side=RIGHT, padx=5, pady=5)
        self.bind("<Return>", self.ok)
        box.pack(side=BOTTOM,fill=X)


    def body(self, master):
        self.resizable(0,0)

        outerframe = Frame(master)
        cache = ImageCache()
        self.gqlImage = cache['Icons/GQL.gif']
        self.label = Label(outerframe, image=self.gqlImage)
        self.label.pack(side=LEFT)
        frame = Frame(outerframe)
        self.label = Label(frame, text=SplashScreen.crnotice1, justify=LEFT)
        self.label.pack(side=TOP,anchor=W)
        label = Label(frame, font="Helvetica 9", text=SplashScreen.crnotice2, justify=LEFT)
        label.pack(side=BOTTOM,anchor=W)
        frame.pack(side=RIGHT)
        outerframe.pack(side=TOP)

        color = self.config("bg")[4]
        self.infoText = ScrolledText(master, relief=FLAT,
                                     padx=3, pady=3,
                                     background=color,
                                     #foreground="black",
                                     wrap='word',
                                     width=60, height=12,
                                     font="Times 10")
        self.infoText.pack(expand=0, fill=X, side=BOTTOM)
        self.infoText.delete('0.0', END)
        self.infoText.insert('0.0', gGPL)
        self.infoText.configure(state=DISABLED)
        self.title("GQL - About")



class SplashScreen(Toplevel):
    """ Provides a splash screen. Usage:

        Subclass and override 'CreateWidgets()'

        In constructor of main window/application call

        - S = SplashScreen(main=self)        (if caller is Toplevel)
        - S = SplashScreen(main=self.master) (if caller is Frame)

        - S.Destroy()  after you are done creating your widgets etc.

    """
    crnotice1 = "Copyright (C) 2003-2004 Alexander Schliep\n"\
                "Copyright (C) 2004 Ivan G. Costa Filho\n"\
                "GQL version %s from %s" % (gGQLVersion,gGQLBuilddate)
    crnotice2 = "Written by Alexander Schliep (alexander@schliep.org)\n"\
                "and Ivan G. Costa (filho@molgen.mpg.de) with\n" \
                "Alexander Schoenhuth, Wasinee Rungsarityotin  and Christine\n" \
                "Steinhoff.\n\n" \
                "For Information see http://ghmm.org/gql\n\n" \
                "GQL comes with ABSOLUTELY NO WARRANTY.\n" \
                "This is free software, and you are welcome to redistribute\n" \
                "it under certain conditions. For details see 'GPL.txt'.\n"

    def __init__(self, master=None):
        Toplevel.__init__(self, master, relief=RAISED, borderwidth=5)
        self.main = master
        if self.main.master != None:
            self.main.master.withdraw()
        self.main.withdraw()
        self.overrideredirect(1)
        self.CreateWidgets()
        self.after_idle(self.CenterOnScreen)
        self.update()
        self.after(500)

    def CenterOnScreen(self):
        self.update_idletasks()
        xmax = self.winfo_screenwidth()
        ymax = self.winfo_screenheight()
        x0 = (xmax - self.winfo_reqwidth()) / 2
        y0 = (ymax - self.winfo_reqheight()) / 2
        self.geometry("+%d+%d" % (x0, y0))

    def CreateWidgets(self):
        cache = ImageCache()
        self.gqlImage = cache['Icons/GQL.gif']
        self.label = Label(self, image=self.gqlImage)
        self.label.pack(side=LEFT)
        frame = Frame(self)
        self.label = Label(frame, text=SplashScreen.crnotice1, justify=LEFT)
        self.label.pack(side=TOP,anchor=W)
        label = Label(frame, font="Helvetica 9", text=SplashScreen.crnotice2, justify=LEFT)
        label.pack(side=BOTTOM,anchor=W)
        frame.pack(side=RIGHT)

    def Destroy(self):
        self.main.update()
        self.main.deiconify()
        self.withdraw()


from Tkinter import _cnfmerge

class ScrolledText(Text):
    def __init__(self, master=None, cnf=None, **kw):
        if cnf is None:
            cnf = {}
        if kw:
            cnf = _cnfmerge((cnf, kw))
        fcnf = {}
        for k in cnf.keys():
            if type(k) == ClassType or k == 'name':
                fcnf[k] = cnf[k]
                del cnf[k]
        #self.frame = master
        self.frame = Frame(master, **fcnf)
	# setting wieghts in the column, so the component can resize?
	#for i in range(20):
        #    self.frame.rowconfigure(i,weight=1)
	#for i in range(60):
        #    self.frame.columnconfigure(i,weight=1)

	borderFrame = Frame(self.frame, relief=SUNKEN, bd=2)
	# no idea why I need to do this here?
	#for i in range(1):
        #    borderFrame.columnconfigure(i,weight=1)
        #    borderFrame.rowconfigure(i,weight=1)

        cnf['name'] = 'text'
        Text.__init__(self, borderFrame, **cnf)
        self.pack(anchor=W, side=TOP, fill=BOTH, expand=1)
        #self.grid(row=0,column=0,rowspan=20,columnspan=60, sticky=NSEW)

        # Vertical scroll bar in a frame and with corner
        vbarFrame = Frame(self.frame,borderwidth=0)
        #vbarFrame.grid(row=0, column=59, rowspan=20,sticky=NSEW)
        self.vbar = Scrollbar(vbarFrame, name='vbar', orient=VERTICAL)
        self.vbar.pack(in_=vbarFrame,side=RIGHT, fill=Y)
        vbarFrame.pack(fill=Y, side=RIGHT, anchor=E)
        self['yscrollcommand'] = self.vbar.set
        self.vbar['command'] = self.yview

        # Horizontal scroll bar
        self.hbar = Scrollbar(borderFrame, name='hbar', orient=HORIZONTAL)
        #self.hbar.grid(row=19, column=0, columnspan=60,sticky=NSEW)
	self.hbar.pack(side=BOTTOM, fill=X,anchor=W)
        self['xscrollcommand'] = self.hbar.set
        self.hbar['command'] = self.xview


        borderFrame.pack(side=TOP, expand=1, fill=BOTH)
	#borderFrame.grid(row=0,column=0,rowspan=20,columnspan=59,sticky=NSEW)

        # Copy geometry methods of self.frame -- hack!
        methods = Pack.__dict__.keys()
        methods = methods + Grid.__dict__.keys()
        methods = methods + Place.__dict__.keys()

        for m in methods:
            if m[0] != '_' and m != 'config' and m != 'configure':
                setattr(self, m, getattr(self.frame, m))




class ResultsBox(tkSimpleDialog.Dialog):
    """ The application's results box """

    def __init__(self,master,text,line2acc,title_text=None):
        self.text = text
        self.line2acc = line2acc
        self.title_text = title_text
        tkSimpleDialog.Dialog.__init__(self,master)


    def buttonbox(self):
        # Stolen from tkSimpleDialog.py
        # add standard button box. override if you don't want the
        # standard buttons
        box = Frame(self)
        w = Button(box, text="OK", width=10, command=self.ok, default=ACTIVE)
        w.pack(side=RIGHT, padx=5, pady=5)
        self.bind("<Return>", self.ok)
        box.pack(side=BOTTOM,fill=X, expand=1)

   
    def body(self, master):
        self.resizable(1,1)

        #XXX tkSimpleDialog.Dialog puts me in a frame which doenst have fill=BOTH

        #color = self.config("bg")[4]
        f = tkFont.Font(self, ("Courier", "10", tkFont.NORMAL))
        
        self.infoText = ScrolledText(master, relief=FLAT,
                                     padx=3, pady=3,
                                     background='white',
                                     #foreground="black",
                                     wrap=NONE,
                                     width=120, height=32,
                                     font="Helvetica 9",
                                     )
        self.infoText.pack(expand=1, fill=BOTH, side=TOP)
        self.infoText.delete('0.0', END)
        self.infoText.insert('0.0', self.text)

        self.infoText.tag_config('NCBIAcc', foreground='blue')
        self.infoText.bind("<ButtonRelease-1>",self.NCBIOutlink)
        #self.infoText.tag_add(tag,'%d.0' % lineNo,'%d.0' % (lineNo + 1))

        self.infoText.configure(state=DISABLED)
        if self.title_text == None:
            self.title("GQL: Query Result")
        else:
            self.title(self.title_text)


    def NCBIOutlink(self,event=None):
        """ Callback for canvas to allow toggeling of breakpoints """
        import string
        import webbrowser
        currLine  = int(string.splitfields(self.infoText.index(CURRENT),'.')[0])
        acc = self.line2acc[currLine-1]
        if acc is None:
            return
        print "NCBIOutlink for '%s'" % self.line2acc[currLine-1]
        url = gNCBIURL % acc
	print url
        webbrowser.open(url)


class ProfileCanvas(Canvas):
    """Parent must have a ProfileInfo method which can display text given
       as argument for mouse-overs
    """
    def __init__(self, parent, tk_master, canvas_width, canvas_height):
        Canvas.__init__(self, tk_master, width=canvas_width, height=canvas_height,
                        background="white")
        self.parent = parent
        self.profileSet = None
        self.tagCounter = 0 # a variable to defining tag names

    def Clear(self):
        self.delete("grid")
        self.delete("profile")
        del(self.drawProfile)
        del(self.profile)
        self.profileSet = None

    def DisplayProfileSet(self, set, centered=True):
        if self.profileSet != None:
            self.delete("profile")
            del(self.drawProfile)
            del(self.profile)

        self.profileSet = set
        # Compute offsets and stuff ...
        canvas_width = float(self.config('width')[4])
        canvas_height = float(self.config('height')[4])

        xscale = canvas_width / self.profileSet.xrange[1] # Assuming profiles start at 0
        #make sure that the profile set doens't take the missing value as the maximun
	maxAbsY = max(abs(self.profileSet.yrange[0]),abs(self.profileSet.yrange[1]))
        maxAbsY += 0.5 # Extra Margin

	if centered:
           self.yrange = [-maxAbsY, maxAbsY] # So everything will be neatly centered
        else:
           self.yrange = set.yrange

        print self.yrange

        yscale = canvas_height / (self.yrange[1] - self.yrange[0])

	if centered:
	    yoffset = canvas_height/2
	else:
	    yoffset = canvas_height + yscale*self.yrange[0]

        self.yoffset = yoffset

        scaled_x = ()
        for i in xrange(self.profileSet.xrange[1]+1):
            scaled_x += (i * xscale,)

        #---- Draw a grid -------------------------------------------
        i = 1
        for x in scaled_x[1:-1]:
            if not i % 5 and self.profileSet.xrange[1] > 10:  # Looks to busy otherwise
                width_ = 1.5
                self.create_text(x,canvas_height,text = "%d" % i,
                                 anchor=SW,justify=RIGHT,tag="grid")
            else:
                width_ = 0.5

            self.create_line(x,0,x,canvas_height,
                              tag="grid",fill="grey",width=width_)

            i += 1

        self.create_line(0,yoffset,canvas_width,yoffset,
                         tag="grid",fill="grey",width=1.5)

        self.create_text(0,yoffset,text = "0.0",
                         anchor=NW,justify=RIGHT,tag="grid")

        if canvas_height / yscale > 5:
            stepwidth = 2
            i = 2
        else:
            i = 1
            stepwidth = 1
        while yoffset + i * yscale < canvas_height:
            #if i % 2:
            #    width_ = 0.5
            #else:
            #    width_ = 1.5

            width_ = 0.5
            self.create_line(0,yoffset + i * yscale,
                             canvas_width,yoffset + i * yscale,
                             tag="grid",fill="grey",width=width_)
            self.create_text(0,yoffset + i * yscale,text = "%1.1f" % (i * -1.0),
                             anchor=NW,justify=RIGHT,tag="grid")
            self.create_line(0,yoffset - i * yscale,
                             canvas_width,yoffset - i * yscale,
                             tag="grid",fill="grey",width=width_)
            self.create_text(0,yoffset - i * yscale,text = "%1.1f" % (i * 1.0),
                             anchor=NW,justify=RIGHT,tag="grid")
            i += stepwidth



        #---- Draw profiles -------------------------------------------

        self.drawProfile = []
        self.profile = {}
        self.tagLookUp = {}

        for i, p in enumerate(self.profileSet):
   	    classe = self.profileSet.getclass(i)
            coords = ()

            for j in xrange(len(p)):
	        # check here if it contains missing data ...
                if p[j] == MISSING_DATA:
                    coords += (scaled_x[j],MISSING_DATA)  # wrong orientation in y coord
                else:
                    coords += (scaled_x[j],-p[j]*yscale + yoffset)  # wrong orientation in y coord

	    # use here the modified create line
	    if classe  == -1:
                c = self.create_multiple_lines(coords,"red")
            else:
                c = self.create_multiple_lines(coords,ClassesColorScheme(classe,self.profileSet.max_class))

            self.drawProfile.append(c)
            self.profile[self.tagCounter] = i

        self.tag_bind("profile", "<Any-Leave>", self.ClearInfo)
        self.tag_bind("profile", "<Any-Enter>", self.ProfileInfo)


    def create_multiple_lines(self,coords,color):
        pos = 0
        self.tagCounter +=1 # getting a new tag id
        newTag = "line%i"%self.tagCounter
        missingInt = []
        #looking for intervals with missing data
        pos = 0
        start = -1
        end = -1
        newCoords = ()
        for i in range(len(coords)/2):
            y = coords[i*2+1]
            if y == MISSING_DATA: # missing data
                if start == -1:
                    if pos == 0: #if first element is missing
                        start = 0
                        y=self.yoffset
                    elif pos == (len(coords)/2-1): #if last element is missing
                        missingInt.append([pos-1,pos])
                        y=self.yoffset
                    else:
                        start = pos - 1
                elif pos == (len(coords)/2-1): #if last element is missing
                    missingInt.append([start,pos])
                    y =self.yoffset
            else:
                if start != -1: # end of missing interval
                   missingInt.append([start,pos])
                   start = -1 # reset interval
            pos += 1
            newCoords += (coords[i*2],y)

        coords = newCoords 
        if missingInt == []:
            c = self.create_line(coords,tag=("profile",newTag),fill=color)
            self.tagLookUp[c] = self.tagCounter
        else:
            init = 0
            for [i,f] in missingInt:  
                if i != 0: # the first point contains missing data
                    # draw normal line
                    if init != i:
                        c = self.create_line(coords[init*2:(i+1)*2],tag=("profile",newTag),fill=color)
                        self.tagLookUp[c] = self.tagCounter
                #draw missing line
                c = self.create_line([coords[i*2],coords[i*2+1],coords[f*2],coords[f*2+1]],
                                     tag=("profile",newTag),fill=color,stipple='gray50')
                self.tagLookUp[c] = self.tagCounter
                init = f
            if missingInt[-1][1] != (len(coords)/2-1) and  missingInt[-1][1] != (len(coords)/2-2):
                # if there is something else in the end ... 
                c = self.create_line(coords[missingInt[-1][1]*2:len(coords)],tag=("profile",newTag),fill=color)
                self.tagLookUp[c] = self.tagCounter
        return newTag

    def ClearInfo(self,event):
        self.parent.ClearInfo()

    def ProfileInfo(self,event):
        #widget = event.widget.find_withtag(CURRENT)[0]
        widgetlist = event.widget.find_overlapping(event.x,event.y,event.x+1,event.y+1)
        for widget in widgetlist:
            if self.itemcget(widget, "fill") != "":
               try: 
                 c = self.tagLookUp[widget]
                 i = self.profile[c]        
                 self.parent.ProfileInfo(self.profileSet.Info(i),i)
                 return
               except KeyError:
                 print "not a sequence"

    def ProfileUpdate(self,showProfiles,hideProfiles):
        for i in showProfiles:
   	    classe = self.profileSet.getclass(i)
	    if classe  == -1:
	        self.itemconfigure(self.drawProfile[i],fill="red")
            else:
	        self.itemconfigure(self.drawProfile[i],fill=ClassesColorScheme(classe,self.profileSet.max_class))

        for i in hideProfiles:
            self.itemconfigure(self.drawProfile[i],fill="")

def ClassesColorScheme(classe,classes_no):
	if classes_no == 0:
	    classes_no = 1
        rgb_tuple = colorsys.hsv_to_rgb(float(classe)/float(classes_no),1.0,1.0)
        hexcolor = '#%02x%02x%02x' % (rgb_tuple[0]*255,rgb_tuple[1]*255,rgb_tuple[2]*255)
        # that's it! '%02x' means zero-padded, 2-digit hex values
        return hexcolor



gGPL = "		    GNU GENERAL PUBLIC LICENSE                                                      \n"\
"		       Version 2, June 1991                                                         \n"\
"                                                                                       \n"\
" Copyright (C) 1989, 1991 Free Software Foundation, Inc.                               \n"\
"                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA         \n"\
" Everyone is permitted to copy and distribute verbatim copies                          \n"\
" of this license document, but changing it is not allowed.                             \n"\
"                                                                                       \n"\
"			    Preamble                                                                      \n"\
"                                                                                       \n"\
"  The licenses for most software are designed to take away your                        \n"\
"freedom to share and change it.  By contrast, the GNU General Public                   \n"\
"License is intended to guarantee your freedom to share and change free                 \n"\
"software--to make sure the software is free for all its users.  This                   \n"\
"General Public License applies to most of the Free Software                            \n"\
"Foundation's software and to any other program whose authors commit to                 \n"\
"using it.  (Some other Free Software Foundation software is covered by                 \n"\
"the GNU Library General Public License instead.)  You can apply it to                  \n"\
"your programs, too.                                                                    \n"\
"                                                                                       \n"\
"  When we speak of free software, we are referring to freedom, not                     \n"\
"price.  Our General Public Licenses are designed to make sure that you                 \n"\
"have the freedom to distribute copies of free software (and charge for                 \n"\
"this service if you wish), that you receive source code or can get it                  \n"\
"if you want it, that you can change the software or use pieces of it                   \n"\
"in new free programs; and that you know you can do these things.                       \n"\
"                                                                                       \n"\
"  To protect your rights, we need to make restrictions that forbid                     \n"\
"anyone to deny you these rights or to ask you to surrender the rights.                 \n"\
"These restrictions translate to certain responsibilities for you if you                \n"\
"distribute copies of the software, or if you modify it.                                \n"\
"                                                                                       \n"\
"  For example, if you distribute copies of such a program, whether                     \n"\
"gratis or for a fee, you must give the recipients all the rights that                  \n"\
"you have.  You must make sure that they, too, receive or can get the                   \n"\
"source code.  And you must show them these terms so they know their                    \n"\
"rights.                                                                                \n"\
"                                                                                       \n"\
"  We protect your rights with two steps: (1) copyright the software, and               \n"\
"(2) offer you this license which gives you legal permission to copy,                   \n"\
"distribute and/or modify the software.                                                 \n"\
"                                                                                       \n"\
"  Also, for each author's protection and ours, we want to make certain                 \n"\
"that everyone understands that there is no warranty for this free                      \n"\
"software.  If the software is modified by someone else and passed on, we               \n"\
"want its recipients to know that what they have is not the original, so                \n"\
"that any problems introduced by others will not reflect on the original                \n"\
"authors' reputations.                                                                  \n"\
"                                                                                       \n"\
"  Finally, any free program is threatened constantly by software                       \n"\
"patents.  We wish to avoid the danger that redistributors of a free                    \n"\
"program will individually obtain patent licenses, in effect making the                 \n"\
"program proprietary.  To prevent this, we have made it clear that any                  \n"\
"patent must be licensed for everyone's free use or not licensed at all.                \n"\
"                                                                                       \n"\
"  The precise terms and conditions for copying, distribution and                       \n"\
"modification follow.                                                                   \n"\
"                                                                                       \n"\
"		    GNU GENERAL PUBLIC LICENSE                                                      \n"\
"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION                     \n"\
"                                                                                       \n"\
"  0. This License applies to any program or other work which contains                  \n"\
"a notice placed by the copyright holder saying it may be distributed                   \n"\
"under the terms of this General Public License.  The \"Program\", below,                 \n"\
"refers to any such program or work, and a \"work based on the Program\"                  \n"\
"means either the Program or any derivative work under copyright law:                   \n"\
"that is to say, a work containing the Program or a portion of it,                      \n"\
"either verbatim or with modifications and/or translated into another                   \n"\
"language.  (Hereinafter, translation is included without limitation in                 \n"\
"the term \"modification\".)  Each licensee is addressed as \"you\".                        \n"\
"                                                                                       \n"\
"Activities other than copying, distribution and modification are not                   \n"\
"covered by this License; they are outside its scope.  The act of                       \n"\
"running the Program is not restricted, and the output from the Program                 \n"\
"is covered only if its contents constitute a work based on the                         \n"\
"Program (independent of having been made by running the Program).                      \n"\
"Whether that is true depends on what the Program does.                                 \n"\
"                                                                                       \n"\
"  1. You may copy and distribute verbatim copies of the Program's                      \n"\
"source code as you receive it, in any medium, provided that you                        \n"\
"conspicuously and appropriately publish on each copy an appropriate                    \n"\
"copyright notice and disclaimer of warranty; keep intact all the                       \n"\
"notices that refer to this License and to the absence of any warranty;                 \n"\
"and give any other recipients of the Program a copy of this License                    \n"\
"along with the Program.                                                                \n"\
"                                                                                       \n"\
"You may charge a fee for the physical act of transferring a copy, and                  \n"\
"you may at your option offer warranty protection in exchange for a fee.                \n"\
"                                                                                       \n"\
"  2. You may modify your copy or copies of the Program or any portion                  \n"\
"of it, thus forming a work based on the Program, and copy and                          \n"\
"distribute such modifications or work under the terms of Section 1                     \n"\
"above, provided that you also meet all of these conditions:                            \n"\
"                                                                                       \n"\
"    a) You must cause the modified files to carry prominent notices                    \n"\
"    stating that you changed the files and the date of any change.                     \n"\
"                                                                                       \n"\
"    b) You must cause any work that you distribute or publish, that in                 \n"\
"    whole or in part contains or is derived from the Program or any                    \n"\
"    part thereof, to be licensed as a whole at no charge to all third                  \n"\
"    parties under the terms of this License.                                           \n"\
"                                                                                       \n"\
"    c) If the modified program normally reads commands interactively                   \n"\
"    when run, you must cause it, when started running for such                         \n"\
"    interactive use in the most ordinary way, to print or display an                   \n"\
"    announcement including an appropriate copyright notice and a                       \n"\
"    notice that there is no warranty (or else, saying that you provide                 \n"\
"    a warranty) and that users may redistribute the program under                      \n"\
"    these conditions, and telling the user how to view a copy of this                  \n"\
"    License.  (Exception: if the Program itself is interactive but                     \n"\
"    does not normally print such an announcement, your work based on                   \n"\
"    the Program is not required to print an announcement.)                             \n"\
"                                                                                       \n"\
"These requirements apply to the modified work as a whole.  If                          \n"\
"identifiable sections of that work are not derived from the Program,                   \n"\
"and can be reasonably considered independent and separate works in                     \n"\
"themselves, then this License, and its terms, do not apply to those                    \n"\
"sections when you distribute them as separate works.  But when you                     \n"\
"distribute the same sections as part of a whole which is a work based                  \n"\
"on the Program, the distribution of the whole must be on the terms of                  \n"\
"this License, whose permissions for other licensees extend to the                      \n"\
"entire whole, and thus to each and every part regardless of who wrote it.              \n"\
"                                                                                       \n"\
"Thus, it is not the intent of this section to claim rights or contest                  \n"\
"your rights to work written entirely by you; rather, the intent is to                  \n"\
"exercise the right to control the distribution of derivative or                        \n"\
"collective works based on the Program.                                                 \n"\
"                                                                                       \n"\
"In addition, mere aggregation of another work not based on the Program                 \n"\
"with the Program (or with a work based on the Program) on a volume of                  \n"\
"a storage or distribution medium does not bring the other work under                   \n"\
"the scope of this License.                                                             \n"\
"                                                                                       \n"\
"  3. You may copy and distribute the Program (or a work based on it,                   \n"\
"under Section 2) in object code or executable form under the terms of                  \n"\
"Sections 1 and 2 above provided that you also do one of the following:                 \n"\
"                                                                                       \n"\
"    a) Accompany it with the complete corresponding machine-readable                   \n"\
"    source code, which must be distributed under the terms of Sections                 \n"\
"    1 and 2 above on a medium customarily used for software interchange; or,           \n"\
"                                                                                       \n"\
"    b) Accompany it with a written offer, valid for at least three                     \n"\
"    years, to give any third party, for a charge no more than your                     \n"\
"    cost of physically performing source distribution, a complete                      \n"\
"    machine-readable copy of the corresponding source code, to be                      \n"\
"    distributed under the terms of Sections 1 and 2 above on a medium                  \n"\
"    customarily used for software interchange; or,                                     \n"\
"                                                                                       \n"\
"    c) Accompany it with the information you received as to the offer                  \n"\
"    to distribute corresponding source code.  (This alternative is                     \n"\
"    allowed only for noncommercial distribution and only if you                        \n"\
"    received the program in object code or executable form with such                   \n"\
"    an offer, in accord with Subsection b above.)                                      \n"\
"                                                                                       \n"\
"The source code for a work means the preferred form of the work for                    \n"\
"making modifications to it.  For an executable work, complete source                   \n"\
"code means all the source code for all modules it contains, plus any                   \n"\
"associated interface definition files, plus the scripts used to                        \n"\
"control compilation and installation of the executable.  However, as a                 \n"\
"special exception, the source code distributed need not include                        \n"\
"anything that is normally distributed (in either source or binary                      \n"\
"form) with the major components (compiler, kernel, and so on) of the                   \n"\
"operating system on which the executable runs, unless that component                   \n"\
"itself accompanies the executable.                                                     \n"\
"                                                                                       \n"\
"If distribution of executable or object code is made by offering                       \n"\
"access to copy from a designated place, then offering equivalent                       \n"\
"access to copy the source code from the same place counts as                           \n"\
"distribution of the source code, even though third parties are not                     \n"\
"compelled to copy the source along with the object code.                               \n"\
"                                                                                       \n"\
"  4. You may not copy, modify, sublicense, or distribute the Program                   \n"\
"except as expressly provided under this License.  Any attempt                          \n"\
"otherwise to copy, modify, sublicense or distribute the Program is                     \n"\
"void, and will automatically terminate your rights under this License.                 \n"\
"However, parties who have received copies, or rights, from you under                   \n"\
"this License will not have their licenses terminated so long as such                   \n"\
"parties remain in full compliance.                                                     \n"\
"                                                                                       \n"\
"  5. You are not required to accept this License, since you have not                   \n"\
"signed it.  However, nothing else grants you permission to modify or                   \n"\
"distribute the Program or its derivative works.  These actions are                     \n"\
"prohibited by law if you do not accept this License.  Therefore, by                    \n"\
"modifying or distributing the Program (or any work based on the                        \n"\
"Program), you indicate your acceptance of this License to do so, and                   \n"\
"all its terms and conditions for copying, distributing or modifying                    \n"\
"the Program or works based on it.                                                      \n"\
"                                                                                       \n"\
"  6. Each time you redistribute the Program (or any work based on the                  \n"\
"Program), the recipient automatically receives a license from the                      \n"\
"original licensor to copy, distribute or modify the Program subject to                 \n"\
"these terms and conditions.  You may not impose any further                            \n"\
"restrictions on the recipients' exercise of the rights granted herein.                 \n"\
"You are not responsible for enforcing compliance by third parties to                   \n"\
"this License.                                                                          \n"\
"                                                                                       \n"\
"  7. If, as a consequence of a court judgment or allegation of patent                  \n"\
"infringement or for any other reason (not limited to patent issues),                   \n"\
"conditions are imposed on you (whether by court order, agreement or                    \n"\
"otherwise) that contradict the conditions of this License, they do not                 \n"\
"excuse you from the conditions of this License.  If you cannot                         \n"\
"distribute so as to satisfy simultaneously your obligations under this                 \n"\
"License and any other pertinent obligations, then as a consequence you                 \n"\
"may not distribute the Program at all.  For example, if a patent                       \n"\
"license would not permit royalty-free redistribution of the Program by                 \n"\
"all those who receive copies directly or indirectly through you, then                  \n"\
"the only way you could satisfy both it and this License would be to                    \n"\
"refrain entirely from distribution of the Program.                                     \n"\
"                                                                                       \n"\
"If any portion of this section is held invalid or unenforceable under                  \n"\
"any particular circumstance, the balance of the section is intended to                 \n"\
"apply and the section as a whole is intended to apply in other                         \n"\
"circumstances.                                                                         \n"\
"                                                                                       \n"\
"It is not the purpose of this section to induce you to infringe any                    \n"\
"patents or other property right claims or to contest validity of any                   \n"\
"such claims; this section has the sole purpose of protecting the                       \n"\
"integrity of the free software distribution system, which is                           \n"\
"implemented by public license practices.  Many people have made                        \n"\
"generous contributions to the wide range of software distributed                       \n"\
"through that system in reliance on consistent application of that                      \n"\
"system; it is up to the author/donor to decide if he or she is willing                 \n"\
"to distribute software through any other system and a licensee cannot                  \n"\
"impose that choice.                                                                    \n"\
"                                                                                       \n"\
"This section is intended to make thoroughly clear what is believed to                  \n"\
"be a consequence of the rest of this License.                                          \n"\
"                                                                                       \n"\
"  8. If the distribution and/or use of the Program is restricted in                    \n"\
"certain countries either by patents or by copyrighted interfaces, the                  \n"\
"original copyright holder who places the Program under this License                    \n"\
"may add an explicit geographical distribution limitation excluding                     \n"\
"those countries, so that distribution is permitted only in or among                    \n"\
"countries not thus excluded.  In such case, this License incorporates                  \n"\
"the limitation as if written in the body of this License.                              \n"\
"                                                                                       \n"\
"  9. The Free Software Foundation may publish revised and/or new versions              \n"\
"of the General Public License from time to time.  Such new versions will               \n"\
"be similar in spirit to the present version, but may differ in detail to               \n"\
"address new problems or concerns.                                                      \n"\
"                                                                                       \n"\
"Each version is given a distinguishing version number.  If the Program                 \n"\
"specifies a version number of this License which applies to it and \"any                \n"\
"later version\", you have the option of following the terms and conditions              \n"\
"either of that version or of any later version published by the Free                   \n"\
"Software Foundation.  If the Program does not specify a version number of              \n"\
"this License, you may choose any version ever published by the Free Software           \n"\
"Foundation.                                                                            \n"\
"                                                                                       \n"\
"  10. If you wish to incorporate parts of the Program into other free                  \n"\
"programs whose distribution conditions are different, write to the author              \n"\
"to ask for permission.  For software which is copyrighted by the Free                  \n"\
"Software Foundation, write to the Free Software Foundation; we sometimes               \n"\
"make exceptions for this.  Our decision will be guided by the two goals                \n"\
"of preserving the free status of all derivatives of our free software and              \n"\
"of promoting the sharing and reuse of software generally.                              \n"\
"                                                                                       \n"\
"			    NO WARRANTY                                                                   \n"\
"                                                                                       \n"\
"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY             \n"\
"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN               \n"\
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES                 \n"\
"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED             \n"\
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF                   \n"\
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS              \n"\
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE                 \n"\
"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,               \n"\
"REPAIR OR CORRECTION.                                                                  \n"\
"                                                                                       \n"\
"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING            \n"\
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR                    \n"\
"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,             \n"\
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING            \n"\
"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED              \n"\
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY               \n"\
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER             \n"\
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE                  \n"\
"POSSIBILITY OF SUCH DAMAGES.                                                           \n"\
"                                                                                       \n"\
"		     END OF TERMS AND CONDITIONS                                                    \n"\
"                                                                                       \n"\
"	    How to Apply These Terms to Your New Programs                                     \n"\
"                                                                                       \n"\
"  If you develop a new program, and you want it to be of the greatest                  \n"\
"possible use to the public, the best way to achieve this is to make it                 \n"\
"free software which everyone can redistribute and change under these terms.            \n"\
"                                                                                       \n"\
"  To do so, attach the following notices to the program.  It is safest                 \n"\
"to attach them to the start of each source file to most effectively                    \n"\
"convey the exclusion of warranty; and each file should have at least                   \n"\
"the \"copyright\" line and a pointer to where the full notice is found.                  \n"\
"                                                                                       \n"\
"    <one line to give the program's name and a brief idea of what it does.>            \n"\
"    Copyright (C) <year>  <name of author>                                             \n"\
"                                                                                       \n"\
"    This program is free software; you can redistribute it and/or modify               \n"\
"    it under the terms of the GNU General Public License as published by               \n"\
"    the Free Software Foundation; either version 2 of the License, or                  \n"\
"    (at your option) any later version.                                                \n"\
"                                                                                       \n"\
"    This program is distributed in the hope that it will be useful,                    \n"\
"    but WITHOUT ANY WARRANTY; without even the implied warranty of                     \n"\
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                      \n"\
"    GNU General Public License for more details.                                       \n"\
"                                                                                       \n"\
"    You should have received a copy of the GNU General Public License                  \n"\
"    along with this program; if not, write to the Free Software                        \n"\
"    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA          \n"\
"                                                                                       \n"\
"                                                                                       \n"\
"Also add information on how to contact you by electronic and paper mail.               \n"\
"                                                                                       \n"\
"If the program is interactive, make it output a short notice like this                 \n"\
"when it starts in an interactive mode:                                                 \n"\
"                                                                                       \n"\
"    Gnomovision version 69, Copyright (C) year name of author                          \n"\
"    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.          \n"\
"    This is free software, and you are welcome to redistribute it                      \n"\
"    under certain conditions; type `show c' for details.                               \n"\
"                                                                                       \n"\
"The hypothetical commands `show w' and `show c' should show the appropriate            \n"\
"parts of the General Public License.  Of course, the commands you use may              \n"\
"be called something other than `show w' and `show c'; they could even be               \n"\
"mouse-clicks or menu items--whatever suits your program.                               \n"\
"                                                                                       \n"\
"You should also get your employer (if you work as a programmer) or your                \n"\
"school, if any, to sign a \"copyright disclaimer\" for the program, if                   \n"\
"necessary.  Here is a sample; alter the names:                                         \n"\
"                                                                                       \n"\
"  Yoyodyne, Inc., hereby disclaims all copyright interest in the program               \n"\
"  `Gnomovision' (which makes passes at compilers) written by James Hacker.             \n"\
"                                                                                       \n"\
"  <signature of Ty Coon>, 1 April 1989                                                 \n"\
"  Ty Coon, President of Vice                                                           \n"\
"                                                                                       \n"\
"This General Public License does not permit incorporating your program into            \n"\
"proprietary programs.  If your program is a subroutine library, you may                \n"\
"consider it more useful to permit linking proprietary applications with the            \n"\
"library.  If this is what you want to do, use the GNU Library General                  \n"\
"Public License instead of this License.                                                "

