from urllib2 import urlopen
from ClientForm import ParseResponse
from sgmllib import SGMLParser

class URLLister(SGMLParser):
    def reset(self):
        SGMLParser.reset(self)
        self.urls = []

    def start_a(self, attrs):
        href = [v for k, v in attrs if k=='href']
        if href:
            self.urls.extend(href)


def goStat(listOfGenes, listOfReferenceGenes ="", database="sgd", pvalue=1,numberOfNodes=30):
    """Small script for getting results trough a post request from GOstat

    the parser is not very robust, so changes in the page format can bring
    problens"""

    forms = ParseResponse(urlopen("http://gostat.molgen.mpg.de/cgi-bin/goStat.pl"))
    form = forms[0]
    #print form

    if listOfGenes == "":
        print "noGenes"
        return [0.0,0.0]

    # setting up the parameters
    form["text1"] = listOfGenes
    form["text2"] = listOfReferenceGenes
    form.set_value([database], "prefix", by_label=True)
    form.set_value(["HTML, GO Stats only"], "displaytype", by_label=True)
    form.set_value([str(pvalue)], "plcutoff", by_label=True)
    form.set_value([str(30)], "ccutoff", by_label=True)
    # form.click() returns a urllib2.Request object
    # (see HTMLForm.click.__doc__ if you don't have urllib2)


    response = urlopen(form.click("submit"))
    parser = URLLister()
    parser.feed(response.read())
    response.close()
    parser.close()

    import webbrowser
    for url in parser.urls:
        #print url
        webbrowser.open("http://gostat.molgen.mpg.de/cgi-bin/"+url)


