package aulaEstruturaDados.br.ufpe.cin.listaint;

public class ListaInt {
	private int dado;
	private ListaInt proximo;

	public ListaInt(int valor) {
		this.dado = valor;
		this.proximo = null;
	}

	public void inserir(int valor) {
		if (this.proximo == null) {
			this.proximo = new ListaInt(valor);
		} else {
			this.proximo.inserir(valor);
		}
	}

	public void remover(int valor) throws ValorNaoEncontradoException {
		if (this.dado == valor) {
			this.dado = this.proximo.dado;
			this.proximo = this.proximo.proximo;
		} else if (this.proximo != null) {
			this.proximo.remover(valor);
		} else {
			throw new ValorNaoEncontradoException();
		}
	}
	
	public String toString() {
		String resposta = "" + this.dado;
		if (this.proximo != null) {
			resposta = resposta + ", " + this.proximo.toString();
		}
		return resposta;
	}

}
