package extra.br.ufpe.cin.dados;

import extra.br.ufpe.cin.banco.ContaAbstrata;
import extra.br.ufpe.cin.iterator.IteratorContaAbstrata;

public interface RepositorioContas {
	  void inserir(ContaAbstrata conta) throws RepositorioException;
	  ContaAbstrata procurar(String numero) throws RepositorioException, ContaNaoEncontradaException;
	  void remover(String numero) throws RepositorioException, ContaNaoEncontradaException;
	  void atualizar(ContaAbstrata conta) throws RepositorioException, ContaNaoEncontradaException;
	  boolean existe(String numero) throws RepositorioException;
	  IteratorContaAbstrata getIterator() throws RepositorioException;
}
