package aula12.br.ufpe.cin.banco;

import aula12.br.ufpe.cin.banco.Conta;

/**
 * Modifique a classe Banco para que seja possivel render juros de uma Poupanca.
 * Adicione no Banco o metodo renderJuros que recebe o numero da poupana por
 * parametro. A taxa de juros deve ser um atributo de Banco.
 * 
 * Modifique a classe Banco para que seja possivel computar o bonus de uma
 * ContaEspecial. O metodo renderBonus de Banco deve receber o numero da
 * ContaEspecial.
 * 
 * Crie o metodo transferir na classe Banco que recebe dois numeros de conta, 
 * um valor e transfere o valor entre as contas
 * 
 */
public class Banco {

	private Conta[] contas;
	private int indice;
	
	private final double TAXA = 0.008;

	public Banco() {
		contas = new Conta[100];
		indice = 0;
	}

	public void cadastrar(Conta conta) {
		contas[indice] = conta;
		indice = indice + 1;
	}

	public void creditar(String numero, double valor) {
		Conta c = this.procurar(numero);
		c.creditar(valor);
	}

	public void debitar(String numero, double valor) {
		Conta c = this.procurar(numero);
		c.debitar(valor);
	}

	public double getSaldo(String numero) {
		Conta c = this.procurar(numero);
		return c.getSaldo();
	}

	public void transferir(String de, String para, double valor) {
		Conta origem = this.procurar(de);
		Conta destino = this.procurar(para);
		origem.debitar(valor);
		destino.creditar(valor);
	}
	
	public void renderJuros(String numero) {
		Conta c = this.procurar(numero);
		if (c instanceof Poupanca) {
			((Poupanca) c).renderJuros(TAXA);
		} 
		else {
			throw new RuntimeException("O numero nao eh de Poupanca");
		}
	}

	public void renderBonus(String numero) {
		Conta c = this.procurar(numero);
		if (c instanceof ContaEspecial) {
			((ContaEspecial) c).renderBonus();
		} 
		else {
			throw new RuntimeException("O numero nao eh de ContaEspecial");
		}
	}

	// perceba que esse metodo eh private
	private Conta procurar(String numero) {
		String n;
		boolean achou = false;
		int i = 0;
		while ((!achou) && (i < indice)) {
			n = contas[i].getNumero();
			if (n.equals(numero)) {
				achou = true;
			} else {
				i = i + 1;
			}
		}
		if (i == indice)
			throw new RuntimeException("Conta nao encontrada");
		return contas[i];
	}
}