package aula11.br.ufpe.cin.banco;

import aula11.br.ufpe.cin.banco.Conta;

/**
 * Defina a classe aula11.br.ufpe.cin.banco.Banco com
 *    - Os seguintes atributos (sempre private):
 *        -> contas - um array de Conta
 *        -> indice - um inteiro que  guarda o indice do array onde 
 *           sera inserido a proxima Conta (inicia pelo indice zero)
 *    - Um construtor que inicializa o array com 100 posicoes e o 
 *      indice com zero
 *    - Os metodos (lembre-se de usar o atributo indice):
 *        -> inserir  - recebe uma Conta e insere no array
 *        -> creditar - recebe o numero de uma conta e o valor a ser 
 *           creditado e faz o credito na conta do array
 *        -> debitar  - recebe o numero e o valor a ser debitado
 *        -> getSaldo - recebe o numero da conta e retorna o saldo

 */
public class Banco {

	private Conta[] contas;
	private int indice;

	public Banco() {
		contas = new Conta[100];
		indice = 0;
	}

	public void cadastrar(Conta conta) {
		contas[indice] = conta;
		indice = indice + 1;
	}

	public void creditar(String numero, double valor) {
		Conta c = this.procurar(numero);
		c.creditar(valor);
	}

	public void debitar(String numero, double valor) {
		Conta c = this.procurar(numero);
		c.debitar(valor);
	}
	
	public double getSaldo(String numero) {
		Conta c = this.procurar(numero);
		return c.getSaldo();
	}
	
	// perceba que esse metodo eh private
	private Conta procurar(String numero) {
		String n;
		boolean achou = false;
		int i = 0;
		while ((!achou) && (i < indice)) {
			n = contas[i].getNumero();
			if (n.equals(numero)) {
				achou = true;
			} else {
				i = i + 1;
			}
		}
		if (i == indice)
			throw new RuntimeException("Conta nao encontrada");
		return contas[i];
	}
}