package aula09.solucaoSlide3;

/**
 * Altere a classe RepositorioDVDsArray para que os metodos procurar e remover 
 * nao tenham codigo duplicado. Ou seja, crie um metodo privado que retorna o 
 * indice do array onde esta o DVD desejado. Faca os metodos procurar e remover 
 * utilizarem este metodo novo
 *    
 */
public class RepositorioDVDsArray {
	private DVD[] dvds;
	private int indice;
	
	public RepositorioDVDsArray(int capacidade) {
		this.dvds = new DVD[capacidade];
		this.indice = 0;
	}
	
	public void inserir(DVD dvd) {
		this.dvds[indice] = dvd;
		indice = indice + 1;
	}
	
	public DVD procurar(int codigo) {
		DVD resposta = null;
		int i = this.getIndice(codigo);
		if(i >= 0) {
			resposta = this.dvds[i];
		}
		return resposta;
	}
	
	public void remover(int codigo) {
		int i = this.getIndice(codigo);
		if(i >= 0) {
			this.dvds[i] = this.dvds[indice-1]; //copia o ultimo elemento do array sobre o elemento a ser removido
			indice = indice - 1;                //ajusta o valor do indice
		}
	}
	
	public String toString() {
		String resposta = "";
		for(int i=0; i< indice; i++) {
			resposta = resposta + "##########\n";
			resposta = resposta + this.dvds[i].toString() + "\n";
		}
		return resposta + "##########";
	}
	
	private int getIndice(int codigo) {
		int resposta = -1;
		for(int i=0; i< indice; i++) {
			DVD aux = this.dvds[i];
			if(aux.getCodigo() == codigo) {
				resposta = i;
			}
		}
		return resposta;
	}
}
