package aula09.solucaoSlide2;

/**
 * Modifique a classe RepositorioDVDsArray para implementar o mtodo toString 
 * que retorna um String com os dados de todos os DVDs inseridos no array, 
 * formatados da seguinte forma:
 *    ##########
 *    Descrio: Matrix
 *    Cdigo: 21
 *    ##########
 *    Descrio: Hulk
 *    Cdigo: 10
 *    ##########
 *    
 */
public class RepositorioDVDsArray {
	private DVD[] dvds;
	private int indice;
	
	public RepositorioDVDsArray(int capacidade) {
		this.dvds = new DVD[capacidade];
		this.indice = 0;
	}
	
	public void inserir(DVD dvd) {
		this.dvds[indice] = dvd;
		indice = indice + 1;
	}
	
	public DVD procurar(int codigo) {
		DVD resposta = null;
		for(int i=0; i< indice; i++) {
			DVD aux = this.dvds[i];
			if(aux.getCodigo() == codigo) {
				resposta = aux;
			}
		}
		return resposta;
	}
	
	public void remover(int codigo) {
		for(int i=0; i< indice; i++) {
			DVD aux = this.dvds[i];
			if(aux.getCodigo() == codigo) {
				this.dvds[i] = this.dvds[indice-1]; //copia o ultimo elemento do array sobre o elemento a ser removido
				indice = indice - 1;                //ajusta o valor do indice
			}
		}
	}
	
	public String toString() {
		String resposta = "";
		for(int i=0; i< indice; i++) {
			resposta = resposta + "##########\n";
			resposta = resposta + this.dvds[i].toString() + "\n";
		}
		return resposta + "##########";
	}
}
