package aula09.solucaoSlide1;

/**
 * Defina a classe RepositorioDVDsArray com:
 *   - Os seguintes atributos (sempre private):
 *      -> dvds   - um array de DVD
 *      -> indice - um inteiro que  guarda o ndice do array onde ser inserido o prximo DVD (inicia pelo ndice zero)
 *   - Um construtor que recebe a capacidade do repositorio (inteira) e inicializa o array com esse tamanho (inicialize o indice)
 *   - Os mtodos (lembre-se de usar o atributo indice):
 *      -> inserir  - recebe um DVD e insere no array
 *      -> procurar - recebe o codigo de um DVD e retorna o DVD
 *      -> remover  -  recebe o codigo de um DVD e remove o DVD
 *      
 */
public class RepositorioDVDsArray {
	private DVD[] dvds;
	private int indice;
	
	public RepositorioDVDsArray(int capacidade) {
		this.dvds = new DVD[capacidade];
		this.indice = 0;
	}
	
	public void inserir(DVD dvd) {
		this.dvds[indice] = dvd;
		indice = indice + 1;
	}
	
	public DVD procurar(int codigo) {
		DVD resposta = null;
		for(int i=0; i< indice; i++) {
			DVD aux = this.dvds[i];
			if(aux.getCodigo() == codigo) {
				resposta = aux;
			}
		}
		return resposta;
	}
	
	public void remover(int codigo) {
		for(int i=0; i< indice; i++) {
			DVD aux = this.dvds[i];
			if(aux.getCodigo() == codigo) {
				this.dvds[i] = this.dvds[indice-1]; //copia o ultimo elemento do array sobre o elemento a ser removido
				indice = indice - 1;                //ajusta o valor do indice
			}
		}
	}
	
}
