package aula09;

/**
 * Defina a classe AulaMatriz com:
 *  - Os seguintes atributos (sempre private):
 *      > matriz - um array de inteiros de duas dimensoes	
 *  - Um construtor que:
 *      > recebe um valor inteiro como parametro
 *      > usa o parametro para inicializar o array bidimensional
 *      > incializa cada posio do array com a soma dos indices da posio
 *  - Os seguintes metodos:
 *      > getMatriz - retorna o atributo 
 *      > getDiagonal - retorna os elementos da diagonal principal do array (em um array de inteiros)
 *      > getLinha - recebe um inteiro e retorna todos os elementos da linha referente (em um array de inteiros); 0 eh a 1a linha
 *      > getColuna - recebe um inteiro e retorna todos os elementos da coluna referente (em um array de inteiros); 0 eh a 1a coluna
 *
 */
public class AulaMatriz {
	private int[][] matriz;
	
	public AulaMatriz(int dimensao) {
		this.matriz = new int[dimensao][dimensao];
		for (int i=0; i<dimensao; i++) {
			for (int j=0; j<dimensao; j++) {
				this.matriz[i][j] = i + j;
			}
		}
	}
	
	public int[][] getMatriz() {
		return this.matriz;	
	}
	
	public int[] getDiagonal() {
		int[] resposta = new int[this.matriz.length];
		for(int i=0; i<this.matriz.length; i++) {
			resposta[i] = this.matriz[i][i];
		}
		return resposta;
	}
	
	//considerando que a linha eh sempre a primeira dimensao
	public int[] getLinha(int linha) {
		int[] resposta = new int[this.matriz.length];
		for(int i=0; i<this.matriz.length; i++) {
			resposta[i] = this.matriz[linha][i];
		}
		return resposta;
	}
	
	//considerando que a coluna eh sempre a segunda dimensao
	public int[] getColuna(int coluna) {
		int[] resposta = new int[this.matriz.length];
		for(int i=0; i<this.matriz.length; i++) {
			resposta[i] = this.matriz[i][coluna];
		}
		return resposta;
	}
}
