import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TelaResultadoBuscaDVD extends JInternalFrame {
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JButton jButtonCancelar = new JButton();
    JButton jButtonAlterar = new JButton();
    JLabel jLabelNome = new JLabel();
    JLabel jLabelGenero = new JLabel();
    JLabel jLabelCensura = new JLabel();
    JLabel jLabelDuracao = new JLabel();
    JLabel jLabelPreco = new JLabel();

    TelaPrincipal principal;
    DVD dvd;
    JButton jButtonExcluir = new JButton();

    public TelaResultadoBuscaDVD(TelaPrincipal p, int codigo) {
        try {
            this.principal = p;
            // BUSCA DVD (WITH LOCK)
            this.dvd = this.principal.servidor.getDVD(codigo);
            if (this.dvd == null) {
                JOptionPane.showMessageDialog(this, "O dvd foi removido por outro usurio.");
                this.dispose();
            } else {
                jbInit();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(392, 323));
        jLabel1.setText("Nome:");
        jLabel1.setBounds(new Rectangle(40, 25, 34, 15));
        this.getContentPane().setLayout(null);
        jLabel2.setText("Gnero:");
        jLabel2.setBounds(new Rectangle(40, 60, 46, 15));
        jLabel3.setText("Censura:");
        jLabel3.setBounds(new Rectangle(40, 95, 51, 15));
        jLabel4.setText("Durao:");
        jLabel4.setBounds(new Rectangle(40, 130, 48, 15));
        jLabel5.setText("Preo:");
        jLabel5.setBounds(new Rectangle(40, 165, 34, 15));
        jButtonCancelar.setBounds(new Rectangle(261, 237, 82, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaResultadoBuscaDVD_jButtonCancelar_actionAdapter(this));
        jButtonAlterar.setBounds(new Rectangle(29, 237, 82, 25));
        jButtonAlterar.setText("Alterar");
        jButtonAlterar.addActionListener(new TelaResultadoBuscaDVD_jButtonAlterar_actionAdapter(this));
        this.setClosable(true);
        this.setTitle("DVD");
        jLabelNome.setText(this.dvd.nome);
        jLabelNome.setBounds(new Rectangle(100, 25, 250, 15));
        jLabelGenero.setText(this.dvd.genero);
        jLabelGenero.setBounds(new Rectangle(100, 60, 150, 15));
        jLabelCensura.setText(this.dvd.censura);
        jLabelCensura.setBounds(new Rectangle(100, 95, 150, 15));
        jLabelDuracao.setText(this.dvd.duracao);
        jLabelDuracao.setBounds(new Rectangle(100, 130, 150, 15));
        jLabelPreco.setText(this.dvd.preco);
        jLabelPreco.setBounds(new Rectangle(100, 165, 150, 15));
        jButtonExcluir.setBounds(new Rectangle(143, 237, 82, 25));
        jButtonExcluir.setText("Excluir");
        jButtonExcluir.addActionListener(new TelaResultadoBuscaDVD_jButtonExcluir_actionAdapter(this));
        this.getContentPane().add(jLabel1, null);
        this.getContentPane().add(jLabel2, null);
        this.getContentPane().add(jLabel3, null);
        this.getContentPane().add(jLabel4, null);
        this.getContentPane().add(jLabel5, null);
        this.getContentPane().add(jLabelGenero, null);
        this.getContentPane().add(jLabelNome, null);
        this.getContentPane().add(jLabelCensura, null);
        this.getContentPane().add(jLabelDuracao, null);
        this.getContentPane().add(jLabelPreco, null);
        this.getContentPane().add(jButtonCancelar, null);
        this.getContentPane().add(jButtonAlterar, null);
        this.getContentPane().add(jButtonExcluir, null);
    }

    void jButtonAlterar_actionPerformed(ActionEvent e) {
        // CHAMA TELA DE ALTERAR DVD
        TelaAlterarDVD tela = new TelaAlterarDVD(this.principal, this.dvd);
        principal.centerWindow(tela);
        principal.desktop.add(tela);
        tela.setVisible(true);
        this.dispose();
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        // COMMIT - TIRA O LOCK
        this.principal.servidor.commit();
        this.dispose();
    }

    void jButtonExcluir_actionPerformed(ActionEvent e) {
        int controle = JOptionPane.showConfirmDialog(null, "Deseja excluir o dvd?", "Excluir Usuario", JOptionPane.YES_NO_OPTION);
        if (controle == JOptionPane.YES_NO_OPTION) {
            // REMOVE CLIENTE
            this.principal.servidor.removerDVD(this.dvd.idDVD);
            // COMMIT -  SALVA E TIRA O LOCK
            this.principal.servidor.commit();
            JOptionPane.showMessageDialog(null,
                                          "DVD excluido com sucesso.",
                                          "Excluir Usuario",
                                          JOptionPane.INFORMATION_MESSAGE);
            this.dispose();
        }
    }
}

class TelaResultadoBuscaDVD_jButtonAlterar_actionAdapter implements java.awt.event.ActionListener {
    TelaResultadoBuscaDVD adaptee;

    TelaResultadoBuscaDVD_jButtonAlterar_actionAdapter(TelaResultadoBuscaDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonAlterar_actionPerformed(e);
    }
}

class TelaResultadoBuscaDVD_jButtonCancelar_actionAdapter implements java.awt.event.ActionListener {
    TelaResultadoBuscaDVD adaptee;

    TelaResultadoBuscaDVD_jButtonCancelar_actionAdapter(TelaResultadoBuscaDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaResultadoBuscaDVD_jButtonExcluir_actionAdapter implements java.awt.event.ActionListener {
    TelaResultadoBuscaDVD adaptee;

    TelaResultadoBuscaDVD_jButtonExcluir_actionAdapter(TelaResultadoBuscaDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExcluir_actionPerformed(e);
    }
}
