import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.rmi.*;

public class TelaResultadoBuscaCliente
    extends JInternalFrame {
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JButton jButtonIniciarLocacao = new JButton();
    JButton jButtonCancelar = new JButton();
    JLabel jLabelNome = new JLabel();
    JLabel jLabelTelefone = new JLabel();
    JLabel jLabelEndereco = new JLabel();
    JButton jButtonExcluir = new JButton();
    JButton jButtonAlterar = new JButton();

    TelaPrincipal principal;
    Cliente cliente;

    public TelaResultadoBuscaCliente(TelaPrincipal p, int codigo) {
        try {
            this.principal = p;
            // BUSCA CLIENTE (WITH LOCK)
            cliente = principal.servidor.getCliente(codigo);
            if (cliente == null) {
                JOptionPane.showMessageDialog(this, "O cliente foi removido do sistema por outro usurio.");
                this.dispose();
            } else {
                jbInit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(457, 358);
        jLabel1.setText("Nome:");
        jLabel1.setBounds(new Rectangle(43, 34, 34, 15));
        this.setClosable(true);
        this.setTitle("Dados do Cliente");
        this.getContentPane().setLayout(null);
        jLabel2.setText("Telefone:");
        jLabel2.setBounds(new Rectangle(43, 74, 50, 15));
        jLabel3.setText("Endereo:");
        jLabel3.setBounds(new Rectangle(43, 117, 54, 15));
        jButtonIniciarLocacao.setBounds(new Rectangle(63, 181, 110, 25));
        jButtonIniciarLocacao.setText("Iniciar Locao");
        jButtonIniciarLocacao.addActionListener(new TelaResultadoBuscaCliente_jButtonIniciarLocacao_actionAdapter(this));
        jButtonCancelar.setBounds(new Rectangle(265, 271, 85, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaResultadoBuscaCliente_jButtonCancelar_actionAdapter(this));
        jLabelNome.setText(cliente.nome);
        jLabelNome.setBounds(new Rectangle(108, 36, 288, 15));
        jLabelTelefone.setText(cliente.telefone);
        jLabelTelefone.setBounds(new Rectangle(108, 76, 137, 15));
        jLabelEndereco.setText(cliente.endereco);
        jLabelEndereco.setBounds(new Rectangle(108, 118, 288, 15));
        jButtonExcluir.setBounds(new Rectangle(63, 271, 110, 25));
        jButtonExcluir.setText("Excluir Cliente");
        jButtonExcluir.addActionListener(new TelaResultadoBuscaCliente_jButtonExcluir_actionAdapter(this));
        jButtonAlterar.setBounds(new Rectangle(63, 226, 110, 25));
        jButtonAlterar.setText("Alterar Dados");
        jButtonAlterar.addActionListener(new TelaResultadoBuscaCliente_jButtonAlterar_actionAdapter(this));
        this.getContentPane().add(jButtonAlterar, null);
        this.getContentPane().add(jLabel1, null);
        this.getContentPane().add(jLabel2, null);
        this.getContentPane().add(jLabel3, null);
        this.getContentPane().add(jLabelNome, null);
        this.getContentPane().add(jLabelTelefone, null);
        this.getContentPane().add(jLabelEndereco, null);
        this.getContentPane().add(jButtonIniciarLocacao, null);
        this.getContentPane().add(jButtonExcluir, null);
        this.getContentPane().add(jButtonCancelar, null);
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        // COMMIT - TIRA O LOCK
        this.principal.servidor.commit();
        this.dispose();
    }

    void jButtonIniciarLocacao_actionPerformed(ActionEvent e) {
        // CHAMA TELA DE INICIAR LOCACAO
        TelaLocacao tela = new TelaLocacao(this.principal, this.cliente);
        principal.centerWindow(tela);
        principal.desktop.add(tela);
        tela.setVisible(true);
        this.dispose();
    }

    void jButtonAlterar_actionPerformed(ActionEvent e) {
        // CHAMA TELA DE ALTERAR CLIENTE
        TelaAlterarCliente tela = new TelaAlterarCliente(this.principal, this.cliente);
        principal.centerWindow(tela);
        principal.desktop.add(tela);
        tela.setVisible(true);
        this.dispose();
    }

    void jButtonExcluir_actionPerformed(ActionEvent e) {
        int controle = JOptionPane.showConfirmDialog(null, "Deseja Excluir o usuario?", "Excluir Usuario", JOptionPane.YES_NO_OPTION);
        if (controle == JOptionPane.YES_NO_OPTION) {
            // REMOVE CLIENTE
            this.principal.servidor.removerCliente(cliente.idCliente);
            // COMMIT -  SALVA E TIRA O LOCK
            this.principal.servidor.commit();
            JOptionPane.showMessageDialog(null,
                                          "Usuario excluido com sucesso",
                                          "Excluir Usuario",
                                          JOptionPane.INFORMATION_MESSAGE);
            this.dispose();
        }
    }
}

class TelaResultadoBuscaCliente_jButtonCancelar_actionAdapter
    implements java.awt.event.ActionListener {
    TelaResultadoBuscaCliente adaptee;

    TelaResultadoBuscaCliente_jButtonCancelar_actionAdapter(TelaResultadoBuscaCliente
        adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaResultadoBuscaCliente_jButtonIniciarLocacao_actionAdapter
    implements java.awt.event.ActionListener {
    TelaResultadoBuscaCliente adaptee;

    TelaResultadoBuscaCliente_jButtonIniciarLocacao_actionAdapter(TelaResultadoBuscaCliente adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonIniciarLocacao_actionPerformed(e);
    }
}

class TelaResultadoBuscaCliente_jButtonAlterar_actionAdapter
    implements java.awt.event.ActionListener {
    TelaResultadoBuscaCliente adaptee;

    TelaResultadoBuscaCliente_jButtonAlterar_actionAdapter(TelaResultadoBuscaCliente adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonAlterar_actionPerformed(e);
    }
}

class TelaResultadoBuscaCliente_jButtonExcluir_actionAdapter
    implements java.awt.event.ActionListener {
    TelaResultadoBuscaCliente adaptee;

    TelaResultadoBuscaCliente_jButtonExcluir_actionAdapter(TelaResultadoBuscaCliente adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExcluir_actionPerformed(e);
    }
}
