import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;


public class TelaPrincipal extends JFrame {
    JDesktopPane desktop = new JDesktopPane();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuCliente = new JMenu();
    JMenuItem jMenuClienteCadastrar = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    JMenu jMenuDVD = new JMenu();
    JMenuItem jMenuDVDCadastrar = new JMenuItem();
    JMenuItem jMenuClienteBuscar = new JMenuItem();
    JMenuItem jMenuDVDBuscar = new JMenuItem();

    Servidor servidor = new ServidorImpl();

    //Construct the frame
    public TelaPrincipal() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //Component initialization
    private void jbInit() throws Exception {
        setContentPane(desktop);
        //contentPane = (JDesktopPane)this.getContentPane();
        //contentPane.setLayout(borderLayout1);
        this.setSize(new Dimension(546, 407));
        this.setTitle("Lock Fcil");
        jMenuCliente.setActionCommand("Cliente");
        jMenuCliente.setText("Cliente");
        jMenuClienteCadastrar.setActionCommand("CadastrarCliente");
        jMenuClienteCadastrar.setText("Cadastrar");
        jMenuClienteCadastrar.addActionListener(new TelaPrincipal_jMenuClienteCadastrar_ActionAdapter(this));
        jMenuDVD.setText("DVD");
        jMenuDVDCadastrar.setText("Cadastrar");
        jMenuDVDCadastrar.addActionListener(new TelaPrincipal_jMenuDVDCadastrar_actionAdapter(this));
        jMenuClienteBuscar.setText("Buscar");
        jMenuClienteBuscar.addActionListener(new TelaPrincipal_jMenuClienteBuscar_actionAdapter(this));
        jMenuDVDBuscar.setText("Buscar");
        jMenuDVDBuscar.addActionListener(new TelaPrincipal_jMenuDVDBuscar_actionAdapter(this));
        jMenuCliente.add(jMenuClienteCadastrar);
        jMenuCliente.add(jMenuClienteBuscar);
        jMenuBar1.add(jMenuCliente);
        jMenuBar1.add(jMenuDVD);
        jMenuDVD.add(jMenuDVDCadastrar);
        jMenuDVD.add(jMenuDVDBuscar);
        this.setJMenuBar(jMenuBar1);
    }

    protected void centerWindow(JInternalFrame frame) {
        Dimension screenSize = this.getContentPane().getSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    //Overridden so we can exit when window is closed
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            System.exit(0);
        }
    }

    public void jMenuClienteCadastrar_actionPerformed(ActionEvent e) {
        TelaCadastrarCliente tela = new TelaCadastrarCliente(this);
        centerWindow(tela);
        tela.setVisible(true);
        desktop.add(tela);
    }

    void jMenuClienteBuscar_actionPerformed(ActionEvent e) {
        TelaBuscarCliente tela = new TelaBuscarCliente(this);
        centerWindow(tela);
        tela.setVisible(true);
        desktop.add(tela);
    }

    void jMenuDVDCadastrar_actionPerformed(ActionEvent e) {
        TelaCadastrarDVD tela = new TelaCadastrarDVD(this);
        centerWindow(tela);
        tela.setVisible(true);
        desktop.add(tela);
    }

    void jMenuDVDBuscar_actionPerformed(ActionEvent e) {
        TelaBuscarDVD tela = new TelaBuscarDVD(this);
        centerWindow(tela);
        tela.setVisible(true);
        desktop.add(tela);
    }
}

class TelaPrincipal_jMenuClienteCadastrar_ActionAdapter
    implements ActionListener {
    TelaPrincipal adaptee;

    TelaPrincipal_jMenuClienteCadastrar_ActionAdapter(TelaPrincipal adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuClienteCadastrar_actionPerformed(e);
    }
}

class TelaPrincipal_jMenuClienteBuscar_actionAdapter implements java.awt.event.ActionListener {
  TelaPrincipal adaptee;

  TelaPrincipal_jMenuClienteBuscar_actionAdapter(TelaPrincipal adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuClienteBuscar_actionPerformed(e);
  }
}

class TelaPrincipal_jMenuDVDCadastrar_actionAdapter implements java.awt.event.ActionListener {
  TelaPrincipal adaptee;

  TelaPrincipal_jMenuDVDCadastrar_actionAdapter(TelaPrincipal adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuDVDCadastrar_actionPerformed(e);
  }
}

class TelaPrincipal_jMenuDVDBuscar_actionAdapter implements java.awt.event.ActionListener {
    TelaPrincipal adaptee;

    TelaPrincipal_jMenuDVDBuscar_actionAdapter(TelaPrincipal adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuDVDBuscar_actionPerformed(e);
    }
}
