import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Iterator;
import java.util.Collections;

public class TelaLocarDVD extends JInternalFrame {
    JTextField jTextFieldNome = new JTextField();
    JTextField jTextFieldCodigo = new JTextField();
    JComboBox jComboBoxGenero = new JComboBox(DVD.generos);
    JButton jButtonBuscar = new JButton();
    JButton jButtonCancelar = new JButton();
    JRadioButton jRadioButtonCodigo = new JRadioButton();
    JRadioButton jRadioButtonNome = new JRadioButton();
    JRadioButton jRadioButtonGenero = new JRadioButton();
    ButtonGroup buttonGroup = new ButtonGroup();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jListDVD = new JList();
    JButton jButtonLocar = new JButton();

    TelaPrincipal principal;
    DVD novoDVD =  null;
    TelaLocacao telaLocacao;

    public TelaLocarDVD(TelaPrincipal p, TelaLocacao l) {
        try {
            this.principal = p;
            this.telaLocacao = l;
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(417, 530);
        this.getContentPane().setLayout(null);
        jTextFieldNome.setText("");
        jTextFieldNome.setBounds(new Rectangle(110, 60, 250, 21));
        jTextFieldCodigo.setDoubleBuffered(false);
        jTextFieldCodigo.setEditable(false);
        jTextFieldCodigo.setText("");
        jTextFieldCodigo.setBounds(new Rectangle(110, 25, 150, 21));
        jComboBoxGenero.setEnabled(false);
        jComboBoxGenero.setBounds(new Rectangle(110, 95, 150, 21));
        jButtonBuscar.setBounds(new Rectangle(37, 154, 82, 25));
        jButtonBuscar.setText("Buscar");
        jButtonBuscar.addActionListener(new TelaLocarDVD_jButtonBuscar_actionAdapter(this));
        jButtonCancelar.setBounds(new Rectangle(225, 462, 82, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaLocarDVD_jButtonCancelar_actionAdapter(this));
        this.setClosable(true);
        this.setTitle("Buscar DVD");
        jRadioButtonCodigo.setText("Cdigo:");
        jRadioButtonCodigo.setBounds(new Rectangle(35, 27, 61, 23));
        jRadioButtonCodigo.addActionListener(new TelaLocarDVD_jRadioButtonCodigo_actionAdapter(this));
        jRadioButtonNome.setSelected(true);
        jRadioButtonNome.setText("Nome:");
        jRadioButtonNome.setBounds(new Rectangle(35, 61, 63, 23));
        jRadioButtonNome.addActionListener(new TelaLocarDVD_jRadioButtonNome_actionAdapter(this));
        jRadioButtonGenero.setText("Gnero:");
        jRadioButtonGenero.setBounds(new Rectangle(35, 94, 68, 23));
        jRadioButtonGenero.addActionListener(new TelaLocarDVD_jRadioButtonGenero_actionAdapter(this));
        jScrollPane1.setBounds(new Rectangle(65, 215, 267, 215));
        jButtonLocar.setBounds(new Rectangle(88, 462, 82, 25));
        jButtonLocar.setText("Locar");
        jButtonLocar.addActionListener(new TelaLocarDVD_jButtonLocar_actionAdapter(this));
        this.getContentPane().add(jComboBoxGenero, null);
        this.getContentPane().add(jTextFieldNome, null);
        this.getContentPane().add(jTextFieldCodigo, null);
        this.getContentPane().add(jButtonBuscar, null);
        this.getContentPane().add(jRadioButtonCodigo, null);
        this.getContentPane().add(jRadioButtonNome, null);
        this.getContentPane().add(jRadioButtonGenero, null);
        this.getContentPane().add(jScrollPane1, null);
        this.getContentPane().add(jButtonCancelar, null);
        this.getContentPane().add(jButtonLocar, null);
        jScrollPane1.getViewport().add(jListDVD, null);
        buttonGroup.add(jRadioButtonCodigo);
        buttonGroup.add(jRadioButtonNome);
        buttonGroup.add(jRadioButtonGenero);
        this.jListDVD.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        // NO D COMMIT QUANDO SAI (PRA NO PERDER OS LOCKS DO CLIENTE E DAS LOCACOES
        this.dispose();
    }

    void jButtonBuscar_actionPerformed(ActionEvent e) {
        // BUSCA DVD'S SEM LOCK
        Vector dvds = new Vector();
        if (this.jRadioButtonCodigo.isSelected()) {
            try {
                int codigo = (new Integer(this.jTextFieldCodigo.getText())).intValue();
                DVD dvd = this.principal.servidor.buscarDVDNaoLocado(codigo);
                if (!this.telaLocacao.novaLocacao.JaTemDVD(dvd)) {
                    dvds.add(dvd);
                }
            } catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "O cdigo precisa ser numrico!");
            }
        } else {
            Vector temp = new Vector();
            if (this.jRadioButtonNome.isSelected()) {
                String nome = this.jTextFieldNome.getText();
                temp = this.principal.servidor.buscarDVDNomeNaoLocado(nome);
            } else {
                if (this.jRadioButtonGenero.isSelected()) {
                    String genero = this.jComboBoxGenero.getSelectedItem().toString();
                    temp = this.principal.servidor.buscarDVDGeneroNaoLocado(genero);
                }
            }
            Iterator i = temp.iterator();
            while (i.hasNext()) {
                DVD dvd = (DVD) i.next();
                if (!this.telaLocacao.novaLocacao.JaTemDVD(dvd)) {
                    dvds.add(dvd);
                }
            }
        }
        Collections.sort(dvds, new OrdemAlfabetica());
        this.jListDVD.setListData(dvds);
        if (dvds.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No h resultados para a busca.");
        }
    }

    void jButtonLocar_actionPerformed(ActionEvent e) {
        if (this.jListDVD.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Selcione um DVD.");
        } else {
            this.novoDVD = (DVD) this.jListDVD.getSelectedValue();
            // D LOCK NO DVD ESCOLHIDO
            this.principal.servidor.getDVD(this.novoDVD.idDVD);
            if (this.principal.servidor.estaLocado(this.novoDVD)) {
                JOptionPane.showMessageDialog(this, "O dvd escolhido foi locado por outro usurio.");
            } else {
                this.telaLocacao.novaLocacao.dvds.add(this.novoDVD);
                Collections.sort(this.telaLocacao.novaLocacao.dvds, new OrdemAlfabetica());
                this.telaLocacao.jListDVDNovos.setListData(this.telaLocacao.novaLocacao.dvds);
                this.telaLocacao.jLabelTotalNova.setText(this.telaLocacao.novaLocacao.getTotal() + ",00");
            }
        }
            this.dispose();
    }

    void jRadioButtonCodigo_actionPerformed(ActionEvent e) {
        this.jTextFieldCodigo.setEditable(true);
        this.jTextFieldNome.setText("");
        this.jTextFieldNome.setEditable(false);
        this.jComboBoxGenero.setEnabled(false);
    }

    void jRadioButtonNome_actionPerformed(ActionEvent e) {
        this.jTextFieldNome.setEditable(true);
        this.jTextFieldCodigo.setText("");
        this.jTextFieldCodigo.setEditable(false);
        this.jComboBoxGenero.setEnabled(false);
    }

    void jRadioButtonGenero_actionPerformed(ActionEvent e) {
        this.jComboBoxGenero.setEnabled(true);
        this.jTextFieldNome.setText("");
        this.jTextFieldNome.setEditable(false);
        this.jTextFieldCodigo.setText("");
        this.jTextFieldCodigo.setEditable(false);
    }
}

class TelaLocarDVD_jButtonCancelar_actionAdapter implements java.awt.event.ActionListener {
    TelaLocarDVD adaptee;

    TelaLocarDVD_jButtonCancelar_actionAdapter(TelaLocarDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaLocarDVD_jButtonBuscar_actionAdapter implements java.awt.event.ActionListener {
    TelaLocarDVD adaptee;

    TelaLocarDVD_jButtonBuscar_actionAdapter(TelaLocarDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonBuscar_actionPerformed(e);
    }
}

class TelaLocarDVD_jButtonLocar_actionAdapter implements java.awt.event.ActionListener {
    TelaLocarDVD adaptee;

    TelaLocarDVD_jButtonLocar_actionAdapter(TelaLocarDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonLocar_actionPerformed(e);
    }
}

class TelaLocarDVD_jRadioButtonCodigo_actionAdapter implements java.awt.event.ActionListener {
    TelaLocarDVD adaptee;

    TelaLocarDVD_jRadioButtonCodigo_actionAdapter(TelaLocarDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jRadioButtonCodigo_actionPerformed(e);
    }
}

class TelaLocarDVD_jRadioButtonNome_actionAdapter implements java.awt.event.ActionListener {
    TelaLocarDVD adaptee;

    TelaLocarDVD_jRadioButtonNome_actionAdapter(TelaLocarDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jRadioButtonNome_actionPerformed(e);
    }
}

class TelaLocarDVD_jRadioButtonGenero_actionAdapter implements java.awt.event.ActionListener {
    TelaLocarDVD adaptee;

    TelaLocarDVD_jRadioButtonGenero_actionAdapter(TelaLocarDVD adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jRadioButtonGenero_actionPerformed(e);
    }
}
