import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;

public class TelaLocacao extends JInternalFrame {
    JLabel jLabel1 = new JLabel();
    JLabel jLabelNomeCliente = new JLabel();
    JPanel jPanel1 = new JPanel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JComboBox jComboBoxCodigos = new JComboBox(DVD.generos);
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabelDataLocacao = new JLabel();
    JLabel jLabelDataEntrega = new JLabel();
    JLabel jLabel6 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jListDVDLocados = new JList();
    JLabel jLabel7 = new JLabel();
    JLabel jLabelTotal = new JLabel();
    JButton jButtonDevolver = new JButton();
    JButton jButtonConfirmar = new JButton();
    JLabel jLabel8 = new JLabel();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabelTotalNova = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    JLabel jLabel10 = new JLabel();
    JLabel jLabelDataLocacaoHoje = new JLabel();
    JLabel jLabel12 = new JLabel();
    JLabel jLabel13 = new JLabel();
    JButton jButtonCancelar = new JButton();
    JTextField jTextFieldDataEntrega = new JTextField();
    JButton jButtonNovoDVD = new JButton();

    TelaPrincipal principal;
    Cliente cliente;
    Locacao novaLocacao;
    JList jListDVDNovos = new JList();

    public TelaLocacao(TelaPrincipal p, Cliente c) {
        try {
            this.principal = p;
            this.cliente = c;
            this.novaLocacao = new Locacao(2, cliente.idCliente, "10/03/2005");
            jbInit();
            // PEGA AS LOCACOES (WITH LOCK)
            this.atualizarLocacoes();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(846, 590);
        jLabel1.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel1.setText("Cliente:");
        jLabel1.setBounds(new Rectangle(48, 29, 46, 15));
        this.getContentPane().setLayout(null);
        jLabelNomeCliente.setBounds(new Rectangle(98, 30, 250, 15));
        jLabelNomeCliente.setText(this.cliente.nome);
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setBounds(new Rectangle(48, 63, 353, 432));
        jPanel1.setLayout(null);
        jLabel2.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel2.setText("Locaes em Andamento:");
        jLabel2.setBounds(new Rectangle(20, 18, 153, 15));
        jLabel3.setText("Cdigo:");
        jLabel3.setBounds(new Rectangle(20, 70, 43, 15));
        jComboBoxCodigos.setBounds(new Rectangle(74, 68, 150, 21));
        jComboBoxCodigos.addItemListener(new TelaLocacao_jComboBoxCodigos_itemAdapter(this));
        jLabel4.setText("Data da Locao:");
        jLabel4.setBounds(new Rectangle(20, 116, 90, 15));
        jLabel5.setText("Data de Entrega:");
        jLabel5.setBounds(new Rectangle(20, 152, 87, 15));
        jLabelDataLocacao.setText("");
        jLabelDataLocacao.setBounds(new Rectangle(120, 117, 100, 15));
        jLabelDataEntrega.setText("");
        jLabelDataEntrega.setBounds(new Rectangle(120, 152, 100, 15));
        jLabel6.setText("DVD\'s:");
        jLabel6.setBounds(new Rectangle(20, 187, 34, 15));
        jScrollPane1.setBounds(new Rectangle(27, 212, 295, 106));
        jLabel7.setVerifyInputWhenFocusTarget(true);
        jLabel7.setText("Total:");
        jLabel7.setBounds(new Rectangle(226, 334, 34, 15));
        jLabelTotal.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabelTotal.setDebugGraphicsOptions(0);
        jLabelTotal.setVerifyInputWhenFocusTarget(true);
        jLabelTotal.setText("0,00");
        jLabelTotal.setBounds(new Rectangle(264, 334, 47, 15));
        jButtonDevolver.setBounds(new Rectangle(107, 380, 134, 25));
        jButtonDevolver.setText("Devolver Locao");
        jButtonDevolver.addActionListener(new TelaLocacao_jButtonDevolver_actionAdapter(this));
        jButtonConfirmar.setText("Confirmar");
        jButtonConfirmar.addActionListener(new TelaLocacao_jButtonConfirmar_actionAdapter(this));
        jButtonConfirmar.setBounds(new Rectangle(128, 370, 86, 25));
        jLabel8.setBounds(new Rectangle(18, 65, 90, 15));
        jLabel8.setText("Data da Locao:");
        jPanel2.setLayout(null);
        jPanel2.setBounds(new Rectangle(443, 62, 353, 432));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jLabel9.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel9.setText("Nova Locao:");
        jLabel9.setBounds(new Rectangle(20, 18, 83, 15));
        jLabelTotalNova.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabelTotalNova.setDebugGraphicsOptions(0);
        jLabelTotalNova.setVerifyInputWhenFocusTarget(true);
        jLabelTotalNova.setText("0,00");
        jLabelTotalNova.setBounds(new Rectangle(262, 293, 47, 15));
        jScrollPane2.setBounds(new Rectangle(24, 170, 295, 106));
        jLabel10.setText("DVD\'s:");
        jLabel10.setBounds(new Rectangle(17, 145, 34, 15));
        jLabelDataLocacaoHoje.setText("10/03/2005");
        jLabelDataLocacaoHoje.setBounds(new Rectangle(113, 67, 100, 15));
        jLabel12.setVerifyInputWhenFocusTarget(true);
        jLabel12.setText("Total:");
        jLabel12.setBounds(new Rectangle(224, 293, 34, 15));
        jLabel13.setText("Data de Entrega:");
        jLabel13.setBounds(new Rectangle(18, 106, 87, 15));
        jButtonCancelar.setBounds(new Rectangle(710, 520, 79, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaLocacao_jButtonCancelar_actionAdapter(this));
        jTextFieldDataEntrega.setText("");
        jTextFieldDataEntrega.setBounds(new Rectangle(114, 102, 96, 21));
        jButtonNovoDVD.setBounds(new Rectangle(33, 288, 90, 25));
        jButtonNovoDVD.setText("Novo DVD");
        jButtonNovoDVD.addActionListener(new TelaLocacao_jButtonNovoDVD_actionAdapter(this));
        this.setTitle("Locaes do Cliente");
        jPanel1.add(jLabel2, null);
        jPanel1.add(jComboBoxCodigos, null);
        jPanel1.add(jLabel3, null);
        jPanel1.add(jLabel4, null);
        jPanel1.add(jLabel5, null);
        jPanel1.add(jLabelDataLocacao, null);
        jPanel1.add(jLabelDataEntrega, null);
        jPanel1.add(jLabel6, null);
        jPanel1.add(jScrollPane1, null);
        jPanel1.add(jLabel7, null);
        jPanel1.add(jLabelTotal, null);
        jPanel1.add(jButtonDevolver, null);
        this.getContentPane().add(jLabel1, null);
        this.getContentPane().add(jLabelNomeCliente, null);
        this.getContentPane().add(jPanel2, null);
        jScrollPane1.getViewport().add(jListDVDLocados, null);
        jPanel2.add(jLabel9, null);
        jPanel2.add(jLabelTotalNova, null);
        jPanel2.add(jLabel12, null);
        jPanel2.add(jScrollPane2, null);
        jScrollPane2.getViewport().add(jListDVDNovos, null);
        jPanel2.add(jButtonNovoDVD, null);
        jPanel2.add(jLabel10, null);
        jPanel2.add(jLabel13, null);
        jPanel2.add(jTextFieldDataEntrega, null);
        jPanel2.add(jLabelDataLocacaoHoje, null);
        jPanel2.add(jLabel8, null);
        jPanel2.add(jButtonConfirmar, null);
        this.getContentPane().add(jButtonCancelar, null);
        this.getContentPane().add(jPanel1, null);
    }

    private void atualizarLocacoes() {
        // PEGA AS LOCACOES DO CLIENTE (WITH LOCK)
        Vector locacoes = this.principal.servidor.getLocacoesCliente(this.cliente);

        this.jComboBoxCodigos.removeAllItems();
        Iterator i = locacoes.iterator();
        while (i.hasNext()) {
            Locacao locacao = (Locacao) i.next();
            this.jComboBoxCodigos.addItem(locacao); // o toString  o cdigo
        }

        if (!locacoes.isEmpty()) {
            this.atualizarLocacaoSelecionada();
        }

        // LOCK NO CLIENTE
        this.principal.servidor.getCliente(this.cliente.idCliente);
    }

    private void removerLocacaoDoJList(Locacao locacao) {

        this.jComboBoxCodigos.removeItem(locacao);

        this.atualizarLocacaoSelecionada();
    }

    private void colocarLocacaoNoJList(Locacao locacao) {

        this.jComboBoxCodigos.addItem(locacao);

        this.atualizarLocacaoSelecionada();
    }



    private void atualizarLocacaoSelecionada() {
        Locacao locacao = (Locacao) this.jComboBoxCodigos.getSelectedItem();
        this.jLabelDataLocacao.setText(locacao.dataLocacao);
        this.jLabelDataEntrega.setText(locacao.dataEntrega);
        this.jListDVDLocados.setListData(locacao.dvds); // o toString  o nome + cod + preco
        this.jLabelTotal.setText(locacao.getTotal() + ",00");
    }

    void jButtonDevolver_actionPerformed(ActionEvent e) {
        if (this.jComboBoxCodigos.getItemCount() > 0) {
            Locacao locacao = (Locacao) this.jComboBoxCodigos.getSelectedItem();
            // REMOVE LOCACAO
            this.principal.servidor.devolverLocacao(locacao);
            // NO D O COMMIT - ATUALIZA APENAS NO JLIST
            this.removerLocacaoDoJList(locacao);

        } else {
            JOptionPane.showMessageDialog(this, "No h locaes para serem devolvidas.");
        }
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        // COMMIT - TIRA O LOCK
        this.principal.servidor.commit();
        this.dispose();
    }

    void jButtonNovoDVD_actionPerformed(ActionEvent e) {
        // CHAMA TELA DE BUSCAR DVD PRA LOCACAO
        TelaLocarDVD tela = new TelaLocarDVD(this.principal, this);
        principal.centerWindow(tela);
        principal.desktop.add(tela);
        tela.setVisible(true);
    }

    void jButtonConfirmar_actionPerformed(ActionEvent e) {
        String dataEntrega = this.jTextFieldDataEntrega.getText();
        if (!"".equals(dataEntrega)) {
            this.novaLocacao.dataEntrega = dataEntrega;
            // FAZ LOCACAO
            this.principal.servidor.fazerLocacao(this.novaLocacao);
            // NO D O COMMIT PARA NO PERDER O LOCK
            // ATUALIZA SOMENTE NO JLIST
            this.colocarLocacaoNoJList(this.novaLocacao);
            this.jListDVDNovos.setListData(new Vector());
            this.jTextFieldDataEntrega.setText("");
            this.jLabelTotalNova.setText("0,00");
            this.novaLocacao = new Locacao(3, cliente.idCliente, "10/03/2005");
        } else {
            JOptionPane.showMessageDialog(this, "Preencha a data de entrega.");
        }
    }

    void jComboBoxCodigos_itemStateChanged(ItemEvent e) {
        if (this.jComboBoxCodigos.getItemCount() > 0) {
            this.atualizarLocacaoSelecionada();
        }
    }
}

class TelaLocacao_jButtonDevolver_actionAdapter implements java.awt.event.ActionListener {
    TelaLocacao adaptee;

    TelaLocacao_jButtonDevolver_actionAdapter(TelaLocacao adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonDevolver_actionPerformed(e);
    }
}

class TelaLocacao_jButtonCancelar_actionAdapter implements java.awt.event.ActionListener {
    TelaLocacao adaptee;

    TelaLocacao_jButtonCancelar_actionAdapter(TelaLocacao adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaLocacao_jButtonNovoDVD_actionAdapter implements java.awt.event.ActionListener {
    TelaLocacao adaptee;

    TelaLocacao_jButtonNovoDVD_actionAdapter(TelaLocacao adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonNovoDVD_actionPerformed(e);
    }
}

class TelaLocacao_jButtonConfirmar_actionAdapter implements java.awt.event.ActionListener {
    TelaLocacao adaptee;

    TelaLocacao_jButtonConfirmar_actionAdapter(TelaLocacao adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonConfirmar_actionPerformed(e);
    }
}

class TelaLocacao_jComboBoxCodigos_itemAdapter implements java.awt.event.ItemListener {
    TelaLocacao adaptee;

    TelaLocacao_jComboBoxCodigos_itemAdapter(TelaLocacao adaptee) {
        this.adaptee = adaptee;
    }
    public void itemStateChanged(ItemEvent e) {
        adaptee.jComboBoxCodigos_itemStateChanged(e);
    }
}
