import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TelaCadastrarCliente extends JInternalFrame {
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField jTextFieldNome = new JTextField();
    JTextField jTextFieldTelefone = new JTextField();
    JTextField jTextFieldEndereco = new JTextField();
    JButton jButtonCadastrar = new JButton();
    JButton jButtonCancelar = new JButton();

    TelaPrincipal principal;

    public TelaCadastrarCliente(TelaPrincipal p) {
        try {
            this.principal = p;
            jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(480, 285);
        jLabel1.setText("Nome:");
        jLabel1.setBounds(new Rectangle(45, 36, 34, 15));
        this.setClosable(true);
        this.setTitle("Cadastrar Cliente");
        this.getContentPane().setLayout(null);
        jLabel2.setText("Telefone:");
        jLabel2.setBounds(new Rectangle(45, 76, 50, 15));
        jLabel3.setText("Endereo:");
        jLabel3.setBounds(new Rectangle(45, 119, 54, 15));
        jTextFieldNome.setText("");
        jTextFieldNome.setBounds(new Rectangle(120, 32, 301, 21));
        jTextFieldTelefone.setText("");
        jTextFieldTelefone.setBounds(new Rectangle(120, 73, 122, 21));
        jTextFieldEndereco.setBounds(new Rectangle(120, 117, 303, 21));
        jButtonCadastrar.setBounds(new Rectangle(111, 205, 87, 25));
        jButtonCadastrar.setText("Cadastrar");
        jButtonCadastrar.addActionListener(new TelaCadastrarCliente_jButtonCadastrar_actionAdapter(this));
        jButtonCancelar.setBounds(new Rectangle(242, 205, 85, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaCadastrarCliente_jButtonCancelar_actionAdapter(this));
        this.getContentPane().add(jButtonCancelar, null);
        this.getContentPane().add(jLabel1, null);
        this.getContentPane().add(jLabel2, null);
        this.getContentPane().add(jLabel3, null);
        this.getContentPane().add(jTextFieldNome, null);
        this.getContentPane().add(jTextFieldTelefone, null);
        this.getContentPane().add(jTextFieldEndereco, null);
        this.getContentPane().add(jButtonCadastrar, null);
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void jButtonCadastrar_actionPerformed(ActionEvent e) {
        String nome = this.jTextFieldNome.getText();
        String telefone = this.jTextFieldTelefone.getText();
        String endereco = this.jTextFieldEndereco.getText();
        if (!"".equals(nome) && !"".equals(telefone) && !"".equals(endereco)) {
            // CADASTRA CLIENTE
            this.principal.servidor.cadastrarCliente(new Cliente(nome, telefone, endereco));
            // COMMIT
            this.principal.servidor.commit();
            JOptionPane.showMessageDialog(this, "Cliente Cadastrado com Sucesso!");
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Preencha todos os campos!");
        }

    }
}

class TelaCadastrarCliente_jButtonCancelar_actionAdapter
    implements java.awt.event.ActionListener {
    TelaCadastrarCliente adaptee;

    TelaCadastrarCliente_jButtonCancelar_actionAdapter(TelaCadastrarCliente
        adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaCadastrarCliente_jButtonCadastrar_actionAdapter implements java.awt.event.ActionListener {
    TelaCadastrarCliente adaptee;

    TelaCadastrarCliente_jButtonCadastrar_actionAdapter(TelaCadastrarCliente adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCadastrar_actionPerformed(e);
    }
}
