import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Iterator;
import java.util.Collections;

public class TelaBuscarDVD extends JInternalFrame {
    JTextField jTextFieldNome = new JTextField();
    JTextField jTextFieldCodigo = new JTextField();
    JComboBox jComboBoxGenero = new JComboBox(DVD.generos);
    JButton jButtonBuscar = new JButton();
    JButton jButtonCancelar = new JButton();
    JRadioButton jRadioButtonCodigo = new JRadioButton();
    JRadioButton jRadioButtonNome = new JRadioButton();
    JRadioButton jRadioButtonGenero = new JRadioButton();
    ButtonGroup buttonGroup = new ButtonGroup();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jListDVD = new JList();
    JButton jButtonVer = new JButton();

    TelaPrincipal principal;

    public TelaBuscarDVD(TelaPrincipal p) {
        try {
            this.principal = p;
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception {
        this.setSize(417, 530);
        this.getContentPane().setLayout(null);
        jTextFieldNome.setText("");
        jTextFieldNome.setBounds(new Rectangle(110, 60, 250, 21));
        jTextFieldCodigo.setDoubleBuffered(false);
        jTextFieldCodigo.setEditable(false);
        jTextFieldCodigo.setText("");
        jTextFieldCodigo.setBounds(new Rectangle(110, 25, 150, 21));
        jComboBoxGenero.setEnabled(false);
        jComboBoxGenero.setBounds(new Rectangle(110, 95, 150, 21));
        jButtonBuscar.setBounds(new Rectangle(37, 154, 82, 25));
        jButtonBuscar.setText("Buscar");
        jButtonBuscar.addActionListener(new TelaBuscarDVD_jButtonBuscar_actionAdapter(this));
        jButtonCancelar.setBounds(new Rectangle(225, 462, 82, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaBuscarDVD_jButtonCancelar_actionAdapter(this));
        this.setClosable(true);
        this.setTitle("Buscar DVD");
        jRadioButtonCodigo.setText("Cdigo:");
        jRadioButtonCodigo.setBounds(new Rectangle(35, 27, 61, 23));
        jRadioButtonCodigo.addActionListener(new TelaBuscarDVD_jRadioButtonCodigo_actionAdapter(this));
        jRadioButtonNome.setSelected(true);
        jRadioButtonNome.setText("Nome:");
        jRadioButtonNome.setBounds(new Rectangle(35, 61, 63, 23));
        jRadioButtonNome.addActionListener(new TelaBuscarDVD_jRadioButtonNome_actionAdapter(this));
        jRadioButtonGenero.setText("Gnero:");
        jRadioButtonGenero.setBounds(new Rectangle(35, 94, 68, 23));
        jRadioButtonGenero.addActionListener(new TelaBuscarDVD_jRadioButtonGenero_actionAdapter(this));
        jScrollPane1.setBounds(new Rectangle(65, 215, 267, 215));
        jButtonVer.setBounds(new Rectangle(88, 462, 82, 25));
        jButtonVer.setText("Ver");
        jButtonVer.addActionListener(new TelaBuscarDVD_jButtonVer_actionAdapter(this));
        this.getContentPane().add(jComboBoxGenero, null);
        this.getContentPane().add(jTextFieldNome, null);
        this.getContentPane().add(jTextFieldCodigo, null);
        this.getContentPane().add(jButtonBuscar, null);
        this.getContentPane().add(jRadioButtonCodigo, null);
        this.getContentPane().add(jRadioButtonNome, null);
        this.getContentPane().add(jRadioButtonGenero, null);
        this.getContentPane().add(jScrollPane1, null);
        this.getContentPane().add(jButtonCancelar, null);
        this.getContentPane().add(jButtonVer, null);
        jScrollPane1.getViewport().add(jListDVD, null);
        buttonGroup.add(jRadioButtonCodigo);
        buttonGroup.add(jRadioButtonNome);
        buttonGroup.add(jRadioButtonGenero);
        this.jListDVD.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        // NO PRECISA DE COMMIT
        this.dispose();
    }

    void jButtonBuscar_actionPerformed(ActionEvent e) {
        Vector dvds = new Vector();
        // CHAMA O BUSCAR DVD (SEM LOCK)
        if (this.jRadioButtonCodigo.isSelected()) {
            try {
                int codigo = (new Integer(this.jTextFieldCodigo.getText())).intValue();
                DVD dvd = this.principal.servidor.buscarDVD(codigo);
                dvds.add(dvd);
            } catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "O cdigo precisa ser numrico!");
            }
        } else if (this.jRadioButtonNome.isSelected()) {
            String nome = this.jTextFieldNome.getText();
            dvds = this.principal.servidor.buscarDVDNome(nome);
        } else if (this.jRadioButtonGenero.isSelected()) {
            String genero = this.jComboBoxGenero.getSelectedItem().toString();
            dvds = this.principal.servidor.buscarDVDGenero(genero);
        }
        Vector nomesDVD = new Vector();
        Iterator i = dvds.iterator();
        while (i.hasNext()) {
            DVD dvd = (DVD) i.next();
            if (dvd != null) {
                nomesDVD.add(dvd.nome);
            }
        }
        Collections.sort(nomesDVD, new OrdemAlfabetica());
        this.jListDVD.setListData(nomesDVD);
        if (nomesDVD.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No h resultados para a busca.");
        }
    }

    void jButtonVer_actionPerformed(ActionEvent e) {
        if (this.jListDVD.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Selcione um DVD.");
        } else {
            String nome = this.jListDVD.getSelectedValue().toString();
            DVD dvd = (DVD)this.principal.servidor.buscarDVDNome(nome).get(0);
            // CHAMA TELA DE RESULTADO DE DVD
            TelaResultadoBuscaDVD tela = new TelaResultadoBuscaDVD(this.principal, dvd.idDVD);
            principal.centerWindow(tela);
            principal.desktop.add(tela);
            tela.setVisible(true);
            this.dispose();
        }
    }

  void jRadioButtonCodigo_actionPerformed(ActionEvent e) {
      this.jTextFieldCodigo.setEditable(true);
      this.jTextFieldNome.setText("");
      this.jTextFieldNome.setEditable(false);
      this.jComboBoxGenero.setEnabled(false);
  }

  void jRadioButtonNome_actionPerformed(ActionEvent e) {
      this.jTextFieldNome.setEditable(true);
      this.jTextFieldCodigo.setText("");
      this.jTextFieldCodigo.setEditable(false);
      this.jComboBoxGenero.setEnabled(false);
  }

    void jRadioButtonGenero_actionPerformed(ActionEvent e) {
        this.jComboBoxGenero.setEnabled(true);
        this.jTextFieldNome.setText("");
        this.jTextFieldNome.setEditable(false);
        this.jTextFieldCodigo.setText("");
        this.jTextFieldCodigo.setEditable(false);
    }
}

class TelaBuscarDVD_jButtonCancelar_actionAdapter implements java.awt.event.ActionListener {
    TelaBuscarDVD adaptee;

    TelaBuscarDVD_jButtonCancelar_actionAdapter(TelaBuscarDVD adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaBuscarDVD_jButtonBuscar_actionAdapter implements java.awt.event.ActionListener {
    TelaBuscarDVD adaptee;

    TelaBuscarDVD_jButtonBuscar_actionAdapter(TelaBuscarDVD adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonBuscar_actionPerformed(e);
    }
}

class TelaBuscarDVD_jButtonVer_actionAdapter implements java.awt.event.ActionListener {
    TelaBuscarDVD adaptee;

    TelaBuscarDVD_jButtonVer_actionAdapter(TelaBuscarDVD adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonVer_actionPerformed(e);
    }
}

class TelaBuscarDVD_jRadioButtonCodigo_actionAdapter implements java.awt.event.ActionListener {
  TelaBuscarDVD adaptee;

  TelaBuscarDVD_jRadioButtonCodigo_actionAdapter(TelaBuscarDVD adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jRadioButtonCodigo_actionPerformed(e);
  }
}

class TelaBuscarDVD_jRadioButtonNome_actionAdapter implements java.awt.event.ActionListener {
  TelaBuscarDVD adaptee;

  TelaBuscarDVD_jRadioButtonNome_actionAdapter(TelaBuscarDVD adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jRadioButtonNome_actionPerformed(e);
  }
}

class TelaBuscarDVD_jRadioButtonGenero_actionAdapter implements java.awt.event.ActionListener {
  TelaBuscarDVD adaptee;

  TelaBuscarDVD_jRadioButtonGenero_actionAdapter(TelaBuscarDVD adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jRadioButtonGenero_actionPerformed(e);
  }
}
