import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Iterator;
import java.util.Collections;

public class TelaBuscarCliente extends JInternalFrame {
    JLabel jLabel1 = new JLabel();
    JTextField jTextFieldNome = new JTextField();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jListClientes = new JList();
    JButton jButtonBuscar = new JButton();
    JButton jButtonVer = new JButton();
    JButton jButtonCancelar = new JButton();

    TelaPrincipal principal;

    public TelaBuscarCliente(TelaPrincipal p) {
        try {
            this.principal = p;
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception {
        this.setLocation(30, 30);
        this.setSize(475, 510);
        jLabel1.setText("Nome:");
        jLabel1.setBounds(new Rectangle(36, 46, 34, 15));
        this.setClosable(true);
        this.setTitle("Buscar Cliente");
        this.getContentPane().setLayout(null);
        jTextFieldNome.setBounds(new Rectangle(84, 44, 249, 21));
        jScrollPane1.setBounds(new Rectangle(66, 108, 309, 288));
        jButtonBuscar.setBounds(new Rectangle(352, 42, 73, 25));
        jButtonBuscar.setToolTipText("");
        jButtonBuscar.setText("Buscar");
        jButtonBuscar.addActionListener(new TelaBuscarCliente_jButtonBuscar_actionAdapter(this));
        jButtonVer.setBounds(new Rectangle(102, 429, 90, 25));
        jButtonVer.setText("Ver");
        jButtonVer.addActionListener(new TelaBuscarCliente_jButtonVer_actionAdapter(this));
        jButtonCancelar.setBounds(new Rectangle(240, 429, 90, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaBuscarCliente_jButtonCancelar_actionAdapter(this));
        this.getContentPane().add(jTextFieldNome, null);
        this.getContentPane().add(jButtonCancelar, null);
        this.getContentPane().add(jScrollPane1, null);
        this.getContentPane().add(jLabel1, null);
        this.getContentPane().add(jButtonBuscar, null);
        this.getContentPane().add(jButtonVer, null);
        jScrollPane1.getViewport().add(jListClientes, null);
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        // NO PRECISA DE COMMIT
        this.dispose();
    }

    void jButtonBuscar_actionPerformed(ActionEvent e) {
        String nome = this.jTextFieldNome.getText();
        Vector clientes = new Vector();
        // CHAMA O BUSCAR CLIENTE (SEM LOCK)
        clientes = this.principal.servidor.buscarCliente(nome);
        if (clientes.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No h resultados para a busca.");
        }
        Collections.sort(clientes, new OrdemAlfabetica());
        this.jListClientes.setListData(clientes);
    }

    void jButtonVer_actionPerformed(ActionEvent e) {
        if (this.jListClientes.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Selecione um cliente!");
        } else {
            Cliente cliente = (Cliente) this.jListClientes.getSelectedValue();
            // CHAMA TELA DE RESULTADO DE CLIENTE
            TelaResultadoBuscaCliente tela = new TelaResultadoBuscaCliente(this.principal, cliente.idCliente);
            principal.centerWindow(tela);
            principal.desktop.add(tela);
            tela.setVisible(true);
            this.dispose();
        }
    }
}

class TelaBuscarCliente_jButtonCancelar_actionAdapter implements java.awt.event.ActionListener {
    TelaBuscarCliente adaptee;

    TelaBuscarCliente_jButtonCancelar_actionAdapter(TelaBuscarCliente adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaBuscarCliente_jButtonBuscar_actionAdapter implements java.awt.event.ActionListener {
    TelaBuscarCliente adaptee;

    TelaBuscarCliente_jButtonBuscar_actionAdapter(TelaBuscarCliente adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonBuscar_actionPerformed(e);
    }
}

class TelaBuscarCliente_jButtonVer_actionAdapter implements java.awt.event.ActionListener {
    TelaBuscarCliente adaptee;

    TelaBuscarCliente_jButtonVer_actionAdapter(TelaBuscarCliente adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonVer_actionPerformed(e);
    }
}
