import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.rmi.*;

public class TelaAlterarCliente extends JInternalFrame {
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField jTextFieldNome = new JTextField();
    JTextField jTextFieldTelefone = new JTextField();
    JTextField jTextFieldEndereco = new JTextField();
    JButton jButtonAlterar = new JButton();
    JButton jButtonCancelar = new JButton();

    TelaPrincipal principal;
    Cliente cliente;
    public TelaAlterarCliente(TelaPrincipal p, Cliente cliente) {
        try {
            this.cliente = cliente;
            this.principal = p;
            jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(471, 278);
        jLabel1.setText("Nome:");
        jLabel1.setBounds(new Rectangle(42, 39, 34, 15));
        this.setClosable(true);
        this.setTitle("Alterar Cliente");
        this.getContentPane().setLayout(null);
        jLabel2.setText("Telefone:");
        jLabel2.setBounds(new Rectangle(42, 79, 50, 15));
        jLabel3.setText("Endereo:");
        jLabel3.setBounds(new Rectangle(42, 122, 54, 15));
        jTextFieldNome.setText(cliente.nome);
        jTextFieldNome.setBounds(new Rectangle(117, 35, 301, 21));
        jTextFieldTelefone.setText(cliente.telefone);
        jTextFieldTelefone.setBounds(new Rectangle(117, 76, 122, 21));
        jTextFieldEndereco.setText(cliente.endereco);
        jTextFieldEndereco.setBounds(new Rectangle(117, 120, 303, 21));
        jButtonAlterar.setBounds(new Rectangle(108, 208, 87, 25));
        jButtonAlterar.setText("Alterar");
        jButtonAlterar.addActionListener(new TelaAlterarCliente_jButtonAlterar_actionAdapter(this));
        jButtonCancelar.setBounds(new Rectangle(239, 208, 85, 25));
        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new TelaAlterarCliente_jButtonCancelar_actionAdapter(this));
        this.getContentPane().add(jButtonCancelar, null);
        this.getContentPane().add(jLabel1, null);
        this.getContentPane().add(jLabel2, null);
        this.getContentPane().add(jLabel3, null);
        this.getContentPane().add(jTextFieldNome, null);
        this.getContentPane().add(jTextFieldTelefone, null);
        this.getContentPane().add(jTextFieldEndereco, null);
        this.getContentPane().add(jButtonAlterar, null);
    }

    void jButtonCancelar_actionPerformed(ActionEvent e) {
        // COMMIT - TIRA O LOCK
        this.principal.servidor.commit();
        this.dispose();
    }

    void jButtonAlterar_actionPerformed(ActionEvent e) {
        this.cliente.nome = jTextFieldNome.getText();
        this.cliente.endereco = jTextFieldEndereco.getText();
        this.cliente.telefone = jTextFieldTelefone.getText();
        // ALTERA CLIENTE
        this.principal.servidor.alterarCliente(this.cliente);
        // COMMIT - SALVA E TIRA O CLOCK
        this.principal.servidor.commit();
        JOptionPane.showMessageDialog(null,
                                      "Cliente alterado com sucesso",
                                      "Alterar Cliente",
                                      JOptionPane.INFORMATION_MESSAGE);
        this.dispose();
    }
}

class TelaAlterarCliente_jButtonCancelar_actionAdapter
    implements java.awt.event.ActionListener {
    TelaAlterarCliente adaptee;

    TelaAlterarCliente_jButtonCancelar_actionAdapter(TelaAlterarCliente
        adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonCancelar_actionPerformed(e);
    }
}

class TelaAlterarCliente_jButtonAlterar_actionAdapter
    implements java.awt.event.ActionListener {
    TelaAlterarCliente adaptee;

    TelaAlterarCliente_jButtonAlterar_actionAdapter(TelaAlterarCliente adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonAlterar_actionPerformed(e);
    }
}
