import java.util.*;
import java.rmi.server.*;
import java.rmi.*;
import java.sql.*;

public class ServidorImpl implements Servidor {

    RepositorioCliente repCliente;
    RepositorioDVD repDVD;
    RepositorioLocacao repLocacao;
    Connection conn;

    public ServidorImpl() {

        super();

        this.conn = new DBManager().getConnection();

        this.repCliente = new RepositorioCliente(this.conn);
        this.repDVD = new RepositorioDVD(this.conn);
        this.repLocacao = new RepositorioLocacao(this.conn);

    }

    public void commit() {
        try {
            conn.commit();
        } catch (java.sql.SQLException se) {
            se.printStackTrace();
        }
    }

    public void cadastrarCliente(Cliente cliente) {

        this.repCliente.cadastrarCliente(cliente);

    }

    public Cliente getCliente(int codigo) {
        Cliente retorno = null;
        retorno = repCliente.getCliente(codigo);
        return retorno;
    }

    public Vector buscarCliente(String nome) {

        return this.repCliente.buscarCliente(nome);

    }

    public void alterarCliente(Cliente cliente) {

        this.repCliente.alterarCliente(cliente);

    }

    public void removerCliente(int codigo) {

        this.repCliente.removerCliente(codigo);

    }

    public void cadastrarDVD(DVD dvd) {

        this.repDVD.cadastrarDVD(dvd);

    }

    public DVD buscarDVD(int codigo) {

        return this.repDVD.buscarDVD(codigo);

    }

    public DVD getDVD(int codigo) {

        return this.repDVD.getDVD(codigo);

    }

    public boolean estaLocado(DVD dvd) {
        return this.repDVD.estaLocado(dvd);
    }

    public Vector buscarDVDNome(String nome) {

        return this.repDVD.buscarDVDNome(nome);

    }

    public Vector buscarDVDGenero(String genero) {

        return this.repDVD.buscarDVDGenero(genero);

    }


    public DVD buscarDVDNaoLocado(int codigo) {
        return this.repDVD.buscarDVDNaoLocado(codigo);
    }

    public Vector buscarDVDNomeNaoLocado(String nome) {
        return this.repDVD.buscarDVDNomeNaoLocado(nome);
    }

    public Vector buscarDVDGeneroNaoLocado(String genero) {
        return this.repDVD.buscarDVDGeneroNaoLocado(genero);
    }

    public void alterarDVD(DVD dvd) {

        this.repDVD.alterarDVD(dvd);

    }

    public void removerDVD(int codigo) {

        this.repDVD.removerDVD(codigo);

    }

    public Vector getLocacoesCliente(Cliente cliente) {

        return this.repLocacao.getLocacoesCliente(cliente);

    }

    public void devolverLocacao(Locacao locacao) {

        this.repLocacao.devolverLocacao(locacao);

    }

    public void locarDVD(DVD dvd) {

        this.repLocacao.locarDVD(dvd);

    }

    public void fazerLocacao(Locacao locacao) {

        this.repLocacao.fazerLocacao(locacao);

    }

}