import java.sql.*;
import java.util.*;

public class RepositorioDVD {

    Connection conn;

    public RepositorioDVD(Connection c) {

        this.conn = c;

    }

    public void cadastrarDVD(DVD dvd) {

        try {

            Statement sta = conn.createStatement();

            String sqlInsertDVD = "INSERT INTO dvd (id_dvd, nome, genero, censura, duracao, preco) VALUES (gen_id(gen_id_dvd, 1), '" + dvd.nome + "', '" + dvd.genero + "', '" + dvd.censura + "', '" + dvd.duracao + "', '" + dvd.preco + "')";

            sta.executeUpdate(sqlInsertDVD);
            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

    }

    public DVD buscarDVD(int codigo) {

        DVD temp = null;
        String nome;
        String genero;
        String censura;
        String duracao;
        String preco;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT nome, genero, censura, duracao, preco FROM dvd WHERE id_dvd = " + codigo;

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            if (resultado.next()) {

                nome = resultado.getString("nome");
                genero = resultado.getString("genero");
                censura = resultado.getString("censura");
                duracao = resultado.getString("duracao");
                preco = resultado.getString("preco");

                temp = new DVD(codigo, nome, genero, censura, duracao, preco);

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return temp;

    }

    public boolean estaLocado(DVD dvd) {

        boolean estaLocado = false;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT dvd.id_dvd FROM dvd, dvd_locacao WHERE dvd.id_dvd = " + dvd.idDVD +
                                  " AND dvd.id_dvd = dvd_locacao.id_dvd";

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            if (resultado.next()) {

                estaLocado = true;

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return estaLocado;

    }

    public DVD getDVD(int codigo) { // WITH LOCK

        DVD temp = null;
        String nome;
        String genero;
        String censura;
        String duracao;
        String preco;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT nome, genero, censura, duracao, preco FROM dvd WHERE id_dvd = " + codigo + " WITH LOCK";

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            if (resultado.next()) {

                nome = resultado.getString("nome");
                genero = resultado.getString("genero");
                censura = resultado.getString("censura");
                duracao = resultado.getString("duracao");
                preco = resultado.getString("preco");

                temp = new DVD(codigo, nome, genero, censura, duracao, preco);

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return temp;

    }

    public DVD buscarDVDNaoLocado(int codigo) {

        DVD temp = null;
        String nome;
        String genero;
        String censura;
        String duracao;
        String preco;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT id_dvd, nome, genero, censura, duracao, preco" +
                " FROM dvd WHERE id_dvd = " + codigo +
                " and dvd.id_dvd not in (select dvd.id_dvd from dvd, locacao, dvd_locacao" +
                " where dvd.id_dvd = dvd_locacao.id_dvd" +
                " and locacao.id_locacao = dvd_locacao.id_locacao);";

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            if (resultado.next()) {

                nome = resultado.getString("nome");
                genero = resultado.getString("genero");
                censura = resultado.getString("censura");
                duracao = resultado.getString("duracao");
                preco = resultado.getString("preco");

                temp = new DVD(codigo, nome, genero, censura, duracao, preco);

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return temp;

    }

    public Vector buscarDVDNome(String nome) {

        Vector retorno = new Vector();

        DVD temp = null;
        int idDVD;
        String nomeDVD;
        String generoDVD;
        String censuraDVD;
        String duracaoDVD;
        String precoDVD;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT id_dvd, nome, genero, censura, duracao, preco FROM dvd WHERE nome LIKE '%" + nome + "%'";

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            while (resultado.next()) {

                idDVD = resultado.getInt("id_dvd");
                nomeDVD = resultado.getString("nome");
                generoDVD = resultado.getString("genero");
                censuraDVD = resultado.getString("censura");
                duracaoDVD = resultado.getString("duracao");
                precoDVD = resultado.getString("preco");

                temp = new DVD(idDVD, nomeDVD, generoDVD, censuraDVD, duracaoDVD, precoDVD);

                retorno.add(temp);

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return retorno;

    }

    public Vector buscarDVDNomeNaoLocado(String nome) {

        Vector retorno = new Vector();

        DVD temp = null;
        int idDVD;
        String nomeDVD;
        String generoDVD;
        String censuraDVD;
        String duracaoDVD;
        String precoDVD;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT id_dvd, nome, genero, censura, duracao, preco" +
                " FROM dvd WHERE nome LIKE '%" + nome + "%'" +
                " and dvd.id_dvd not in (select dvd.id_dvd from dvd, locacao, dvd_locacao" +
                " where dvd.id_dvd = dvd_locacao.id_dvd" +
                " and locacao.id_locacao = dvd_locacao.id_locacao);";

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            while (resultado.next()) {

                idDVD = resultado.getInt("id_dvd");
                nomeDVD = resultado.getString("nome");
                generoDVD = resultado.getString("genero");
                censuraDVD = resultado.getString("censura");
                duracaoDVD = resultado.getString("duracao");
                precoDVD = resultado.getString("preco");

                temp = new DVD(idDVD, nomeDVD, generoDVD, censuraDVD, duracaoDVD, precoDVD);

                retorno.add(temp);

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return retorno;
    }

    public Vector buscarDVDGenero(String genero) {

        Vector retorno = new Vector();

        DVD temp = null;
        int idDVD;
        String nomeDVD;
        String generoDVD;
        String censuraDVD;
        String duracaoDVD;
        String precoDVD;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT id_dvd, nome, genero, censura, duracao, preco FROM dvd WHERE genero LIKE '" + genero + "'";

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            while (resultado.next()) {

                idDVD = resultado.getInt("id_dvd");
                nomeDVD = resultado.getString("nome");
                generoDVD = resultado.getString("genero");
                censuraDVD = resultado.getString("censura");
                duracaoDVD = resultado.getString("duracao");
                precoDVD = resultado.getString("preco");

                temp = new DVD(idDVD, nomeDVD, generoDVD, censuraDVD,
                               duracaoDVD, precoDVD);

                retorno.add(temp);

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return retorno;

    }

    public Vector buscarDVDGeneroNaoLocado(String genero) {

        Vector retorno = new Vector();

        DVD temp = null;
        int idDVD;
        String nomeDVD;
        String generoDVD;
        String censuraDVD;
        String duracaoDVD;
        String precoDVD;

        try {

            Statement sta = conn.createStatement();

            String sqlSelectDVD = "SELECT id_dvd, nome, genero, censura, duracao, preco" +
                " FROM dvd WHERE genero LIKE '" + genero + "'" +
                " and dvd.id_dvd not in (select dvd.id_dvd from dvd, locacao, dvd_locacao" +
                " where dvd.id_dvd = dvd_locacao.id_dvd" +
                " and locacao.id_locacao = dvd_locacao.id_locacao);";

            ResultSet resultado = sta.executeQuery(sqlSelectDVD);

            while (resultado.next()) {

                idDVD = resultado.getInt("id_dvd");
                nomeDVD = resultado.getString("nome");
                generoDVD = resultado.getString("genero");
                censuraDVD = resultado.getString("censura");
                duracaoDVD = resultado.getString("duracao");
                precoDVD = resultado.getString("preco");

                temp = new DVD(idDVD, nomeDVD, generoDVD, censuraDVD,
                               duracaoDVD, precoDVD);

                retorno.add(temp);

            }

            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

        return retorno;

    }

    public void alterarDVD(DVD dvd) {

        try {

            Statement sta = conn.createStatement();

            // WITH LOCK
            String sqlUpdateDVD = "UPDATE dvd SET nome = '" + dvd.nome + "', genero = '" + dvd.genero + "', censura = '" + dvd.censura + "', duracao = '" + dvd.duracao + "', preco = '" + dvd.preco + "' WHERE id_dvd = " + dvd.idDVD;

            sta.executeUpdate(sqlUpdateDVD);
            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

    }

    public void removerDVD(int codigo) {

        try {

            Statement sta = conn.createStatement();

            String sqlDeleteDVD = "DELETE FROM dvd WHERE id_dvd = " + codigo;

            sta.executeUpdate(sqlDeleteDVD);
            sta.close();

        } catch (SQLException ex) {

            ex.printStackTrace();

        }

    }

    /*public static void main(String[] args) {
     RepositorioDVD repDVD = new RepositorioDVD();
     DVD dvd1 = new DVD(0, "LOTR", "aventura", "livre", "150", "5,00");
     DVD dvd2 = new DVD(0, "LOTR2", "aventura", "livre", "200", "6,00");
     //repDVD.cadastrarDVD(dvd1);
     //repDVD.cadastrarDVD(dvd2);
     Vector temp = repDVD.buscarDVDNome("LOTR2");
     for(int i = 0; i < temp.size(); i++) {
      System.out.println(((DVD)temp.get(i)).nome);
     }
     Vector temp2 = repDVD.buscarDVDGenero("aventura");
     for(int i = 0; i < temp2.size(); i++) {
      System.out.println(((DVD)temp2.get(i)).nome);
      dvd2 = (DVD) temp2.get(i);
     }
     DVD dvd3 = repDVD.buscarDVD(dvd2.idDVD);
     System.out.println(dvd3.nome);
     dvd3.nome = "LOTR3";
     dvd3.preco = "8,00";
     repDVD.alterarDVD(dvd3);
     repDVD.removerDVD(dvd3.idDVD);
      }*/

}