/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.firebirdsql.gds.GDSFactory;
import org.firebirdsql.gds.GDSType;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.AbstractConnectionPool;
import org.firebirdsql.pool.BasicAbstractConnectionPool;
import org.firebirdsql.pool.FBPooledConnection;
import org.firebirdsql.pool.FirebirdPool;
import org.firebirdsql.pool.PingablePooledConnection;
import org.firebirdsql.pool.PooledConnectionEventListener;
import org.firebirdsql.pool.PooledConnectionManager;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledObjectEvent;
import org.firebirdsql.pool.UnknownDriverTypeException;

public class FBConnectionPoolDataSource
extends BasicAbstractConnectionPool
implements PooledConnectionManager,
ConnectionPoolDataSource,
XADataSource,
PooledConnectionEventListener,
FirebirdPool {
    public static final String USER_NAME_PROPERTY = "user";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String TPB_MAPPING_PROPERTY = "tpb_mapping";
    public static final String BLOB_BUFFER_PROPERTY = "blob_buffer_length";
    public static final String ENCODING_PROPERTY = "lc_ctype";
    public static final String SOCKET_BUFFER_PROPERTY = "socket_buffer_size";
    public static final String SQL_ROLE_PROPERTY = "sql_role_name";
    private static final HashMap PROPERTY_NAME_MAPPING = new HashMap();
    public static final AbstractConnectionPool.UserPasswordPair EMPTY_USER_PASSWORD;
    private static final String PING_STATEMENT = "SELECT cast(1 AS INTEGER) FROM rdb$database";
    private static final Logger LOG;
    private transient PrintWriter logWriter;
    private transient FBManagedConnectionFactory managedConnectionFactory;
    private Properties properties = new Properties();
    private String database;
    private GDSType gdsType = GDSType.PURE_JAVA;
    private static final String REF_DATABASE = "database";
    private static final String REF_TYPE = "type";
    private static final String REF_PROPERTIES = "properties";
    private static final String REF_NON_STANDARD_PROPERTY = "nonStandard";
    static /* synthetic */ Class class$org$firebirdsql$pool$FBConnectionPoolDataSource;

    private synchronized FBManagedConnectionFactory getManagedConnectionFactory() {
        if (this.managedConnectionFactory == null) {
            this.managedConnectionFactory = new FBManagedConnectionFactory(this.getGDSType());
            this.managedConnectionFactory.setDatabase(this.getDatabase());
            FBConnectionRequestInfo defaultCri = this.managedConnectionFactory.getDefaultConnectionRequestInfo();
            FBConnectionRequestInfo cri = FBConnectionHelper.getCri(this.getProperties(), defaultCri);
            this.managedConnectionFactory.setConnectionRequestInfo(cri);
        }
        return this.managedConnectionFactory;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected PooledConnectionManager getConnectionManager() {
        return this;
    }

    public PooledObject allocateConnection(Object key) throws SQLException {
        if (!(key instanceof AbstractConnectionPool.UserPasswordPair)) {
            throw new SQLException("Incorrect key.");
        }
        AbstractConnectionPool.UserPasswordPair pair = (AbstractConnectionPool.UserPasswordPair)key;
        String userName = pair.getUserName();
        String password = pair.getPassword();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getProperties());
        if (userName != null) {
            props.setProperty(USER_NAME_PROPERTY, userName);
        }
        if (password != null) {
            props.setProperty(PASSWORD_PROPERTY, password);
        }
        props = FBDriverPropertyManager.normalize(null, props);
        FBConnectionRequestInfo defaultCri = this.getManagedConnectionFactory().getDefaultConnectionRequestInfo();
        FBConnectionRequestInfo cri = FBConnectionHelper.getCri(props, GDSFactory.getGDSForType(this.getGDSType()));
        try {
            FBManagedConnection managedConnection = (FBManagedConnection)this.getManagedConnectionFactory().createManagedConnection(null, cri);
            FBPooledConnection pooledConnection = null;
            pooledConnection = this.isPingable() ? new FBPooledConnection(managedConnection, cri, this.getPingStatement(), this.getPingInterval(), this.isStatementPooling(), this.getTransactionIsolationLevel(), this.getMaxStatements(), this.isKeepStatements()) : new FBPooledConnection(managedConnection, cri, this.isStatementPooling(), this.getTransactionIsolationLevel(), this.getMaxStatements(), this.isKeepStatements());
            return pooledConnection;
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    protected String getPoolName() {
        return this.getDatabase();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public int getLoginTimeout() {
        return this.getBlockingTimeout() / 1000;
    }

    public void setLoginTimeout(int seconds) {
        this.setBlockingTimeout(seconds * 1000);
    }

    protected synchronized PooledObject getPooledConnection(PooledConnectionQueue queue) throws SQLException {
        PingablePooledConnection connection = (PingablePooledConnection)super.getPooledConnection(queue);
        connection.addConnectionEventListener(this);
        return connection;
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(EMPTY_USER_PASSWORD)));
    }

    public synchronized PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(new AbstractConnectionPool.UserPasswordPair(user, password))));
    }

    public XAConnection getXAConnection() throws SQLException {
        return (XAConnection)this.getPooledConnection();
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return (XAConnection)this.getPooledConnection(user, password);
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource());
        this.pooledObjectReleased(event);
    }

    public void physicalConnectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.pooledObjectReleased(event);
    }

    public void physicalConnectionDeallocated(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.physicalConnectionDeallocated(event);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.getLogger() != null) {
            this.getLogger().error("Error occured in connection.", event.getSQLException());
        }
    }

    public int getFreeSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).size();
    }

    public int getTotalSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).totalSize();
    }

    public int getWorkingSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).workingSize();
    }

    public String getDatabase() {
        return this.database;
    }

    public Properties getProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        return result;
    }

    private String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    private int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public boolean isPingable() {
        return true;
    }

    public String getPingStatement() {
        String pingStatement = super.getPingStatement();
        if (pingStatement != null) {
            return pingStatement;
        }
        return PING_STATEMENT;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("Specified properties are null.");
        }
        this.properties.putAll((Map<?, ?>)properties);
    }

    private void setProperty(String name, String value) {
        String canonicalName = (String)PROPERTY_NAME_MAPPING.get(name);
        if (canonicalName == null) {
            canonicalName = name;
        }
        this.properties.setProperty(canonicalName, value);
    }

    public void setIntProperty(String name, int value) {
        this.setProperty(name, Integer.toString(value));
    }

    public String getType() {
        return this.getGDSType().toString();
    }

    public void setType(String type) throws SQLException {
        GDSType gdsType = GDSType.getType(type);
        if (gdsType == null) {
            throw new UnknownDriverTypeException(type);
        }
        this.setGDSType(gdsType);
    }

    public GDSType getGDSType() {
        return this.gdsType;
    }

    public void setGDSType(GDSType gdsType) {
        this.gdsType = gdsType;
    }

    public String getNonStandardProperty(String key) {
        return this.getProperty(key);
    }

    public void setNonStandardProperty(String key, String value) {
        this.setProperty(key, value);
    }

    public void setNonStandardProperty(String propertyMapping) {
        char[] chars = propertyMapping.toCharArray();
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        boolean keyProcessed = false;
        for (int i = 0; i < chars.length; ++i) {
            boolean isSeparator;
            char ch = chars[i];
            boolean bl = isSeparator = Character.isWhitespace(ch) || ch == '=' || ch == ':';
            if (key.length() == 0 && isSeparator) continue;
            if (!keyProcessed && !isSeparator) {
                key.append(ch);
                continue;
            }
            if (!keyProcessed && isSeparator) {
                keyProcessed = true;
                continue;
            }
            if (keyProcessed && value.length() == 0 && isSeparator || !keyProcessed) continue;
            value.append(ch);
        }
        String keyStr = key.toString().trim();
        String valueStr = value.length() > 0 ? value.toString().trim() : null;
        this.setProperty(keyStr, valueStr);
    }

    public int getBlobBufferSize() {
        if (this.getProperty(BLOB_BUFFER_PROPERTY) != null) {
            return this.getIntProperty(BLOB_BUFFER_PROPERTY);
        }
        return 16384;
    }

    public void setBlobBufferSize(int blobBufferSize) {
        this.setIntProperty(BLOB_BUFFER_PROPERTY, blobBufferSize);
    }

    public String getEncoding() {
        return this.getProperty(ENCODING_PROPERTY);
    }

    public void setEncoding(String encoding) {
        this.setProperty(ENCODING_PROPERTY, encoding);
    }

    public String getCharSet() {
        return FBConnectionHelper.getJavaEncoding(this.getEncoding());
    }

    public void setCharSet(String charSet) throws SQLException {
        String iscEncoding = FBConnectionHelper.getIscEncoding(charSet);
        if (iscEncoding == null) {
            throw new SQLException("Unknown character set " + charSet);
        }
        this.setEncoding(iscEncoding);
    }

    public String getPassword() {
        return this.getProperty(PASSWORD_PROPERTY);
    }

    public void setPassword(String password) {
        this.setProperty(PASSWORD_PROPERTY, password);
    }

    public int getSocketBufferSize() {
        if (this.getProperty(SOCKET_BUFFER_PROPERTY) != null) {
            return this.getIntProperty(SOCKET_BUFFER_PROPERTY);
        }
        return -1;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.setIntProperty(SOCKET_BUFFER_PROPERTY, socketBufferSize);
    }

    public String getRoleName() {
        return this.getProperty(SQL_ROLE_PROPERTY);
    }

    public void setRoleName(String roleName) {
        this.setProperty(SQL_ROLE_PROPERTY, roleName);
    }

    public String getSqlRole() {
        return this.getRoleName();
    }

    public void setSqlRole(String sqlRole) {
        this.setRoleName(sqlRole);
    }

    public String getTpbMapping() {
        return this.getProperty(TPB_MAPPING_PROPERTY);
    }

    public void setTpbMapping(String tpbMapping) {
        this.setProperty(TPB_MAPPING_PROPERTY, tpbMapping);
    }

    public String getUserName() {
        return this.getProperty(USER_NAME_PROPERTY);
    }

    public void setUserName(String userName) {
        this.setProperty(USER_NAME_PROPERTY, userName);
    }

    public Reference getDefaultReference() {
        Reference ref = super.getDefaultReference();
        if (this.getDatabase() != null) {
            ref.add(new StringRefAddr(REF_DATABASE, this.getDatabase()));
        }
        if (this.getType() != null) {
            ref.add(new StringRefAddr(REF_TYPE, this.getType()));
        }
        byte[] data = FBConnectionPoolDataSource.serialize(this.getProperties());
        ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
        return ref;
    }

    protected BasicAbstractConnectionPool createObjectInstance() {
        return new FBConnectionPoolDataSource();
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        FBConnectionPoolDataSource ds = (FBConnectionPoolDataSource)super.getObjectInstance((Object)(ref = (Reference)ref.clone()), name, nameCtx, environment);
        if (ds == null) {
            return null;
        }
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr element = ref.get(i);
            String type = element.getType();
            if (REF_DATABASE.equals(type)) {
                ds.setDatabase(element.getContent().toString());
                continue;
            }
            if (REF_TYPE.equals(type)) {
                ds.setType(element.getContent().toString());
                continue;
            }
            if (REF_PROPERTIES.equals(element.getType())) {
                byte[] data = (byte[])element.getContent();
                Properties props = (Properties)FBConnectionPoolDataSource.deserialize(data);
                if (props == null) continue;
                ds.setProperties(props);
                continue;
            }
            if (REF_NON_STANDARD_PROPERTY.equals(type)) {
                ds.setNonStandardProperty(element.getContent().toString());
                continue;
            }
            if (!(element.getContent() instanceof String)) continue;
            ds.setProperty(type, element.getContent().toString());
        }
        return ds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROPERTY_NAME_MAPPING.put("blobBufferSize", BLOB_BUFFER_PROPERTY);
        PROPERTY_NAME_MAPPING.put("encoding", ENCODING_PROPERTY);
        PROPERTY_NAME_MAPPING.put("userName", USER_NAME_PROPERTY);
        PROPERTY_NAME_MAPPING.put("socketBufferSize", SOCKET_BUFFER_PROPERTY);
        PROPERTY_NAME_MAPPING.put("sqlRole", SQL_ROLE_PROPERTY);
        PROPERTY_NAME_MAPPING.put("roleName", SQL_ROLE_PROPERTY);
        PROPERTY_NAME_MAPPING.put("tpbMapping", TPB_MAPPING_PROPERTY);
        EMPTY_USER_PASSWORD = new AbstractConnectionPool.UserPasswordPair();
        LOG = LoggerFactory.getLogger(class$org$firebirdsql$pool$FBConnectionPoolDataSource == null ? (class$org$firebirdsql$pool$FBConnectionPoolDataSource = FBConnectionPoolDataSource.class$("org.firebirdsql.pool.FBConnectionPoolDataSource")) : class$org$firebirdsql$pool$FBConnectionPoolDataSource, false);
    }
}

