/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.AbstractConnectionPool;
import org.firebirdsql.pool.BasicAbstractConnectionPool;
import org.firebirdsql.pool.PingablePooledConnection;
import org.firebirdsql.pool.PooledConnectionEventListener;
import org.firebirdsql.pool.PooledConnectionManager;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledObjectEvent;

public class DriverConnectionPoolDataSource
extends BasicAbstractConnectionPool
implements ConnectionPoolDataSource,
PooledConnectionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(class$org$firebirdsql$pool$DriverConnectionPoolDataSource == null ? (class$org$firebirdsql$pool$DriverConnectionPoolDataSource = DriverConnectionPoolDataSource.class$("org.firebirdsql.pool.DriverConnectionPoolDataSource")) : class$org$firebirdsql$pool$DriverConnectionPoolDataSource, false);
    public static final AbstractConnectionPool.UserPasswordPair EMPTY_USER_PASSWORD = new AbstractConnectionPool.UserPasswordPair();
    private PrintWriter logWriter;
    private String jdbcUrl;
    private String driverClassName;
    private Properties props = new Properties();
    private DriverPooledConnectionManager connectionManager = new DriverPooledConnectionManager();
    private static final String PROPERTIES = "properties";
    private static final String DRIVER_CLASS_NAME = "driverClassName";
    private static final String JDBC_URL = "jdbcUrl";
    static /* synthetic */ Class class$org$firebirdsql$pool$DriverConnectionPoolDataSource;

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("Specified properties are null.");
        }
        this.props.putAll((Map<?, ?>)properties);
    }

    protected Logger getLogger() {
        return logger;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public int getLoginTimeout() {
        return this.getBlockingTimeout() / 1000;
    }

    public void setLoginTimeout(int seconds) {
        this.setBlockingTimeout(seconds * 1000);
    }

    protected PooledConnectionManager getConnectionManager() throws SQLException {
        return this.connectionManager;
    }

    protected String getPoolName() {
        return this.getJdbcUrl();
    }

    protected synchronized PooledObject getPooledConnection(PooledConnectionQueue queue) throws SQLException {
        PingablePooledConnection connection = (PingablePooledConnection)super.getPooledConnection(queue);
        connection.addConnectionEventListener(this);
        return connection;
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(EMPTY_USER_PASSWORD)));
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(new AbstractConnectionPool.UserPasswordPair(user, password))));
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource());
        this.pooledObjectReleased(event);
    }

    public void physicalConnectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.pooledObjectReleased(event);
    }

    public void physicalConnectionDeallocated(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.physicalConnectionDeallocated(event);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.getLogger() != null) {
            this.getLogger().error("Error occured in connection.", event.getSQLException());
        }
    }

    public int getFreeSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).size();
    }

    public int getTotalSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).totalSize();
    }

    public int getWorkingSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).workingSize();
    }

    protected BasicAbstractConnectionPool createObjectInstance() {
        return new DriverConnectionPoolDataSource();
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        byte[] data;
        Properties props;
        RefAddr binAddr;
        DriverConnectionPoolDataSource ds = (DriverConnectionPoolDataSource)super.getObjectInstance(obj, name, nameCtx, environment);
        if (ds == null) {
            return null;
        }
        Reference ref = (Reference)obj;
        String addr = this.getRefAddr(ref, DRIVER_CLASS_NAME);
        if (addr != null) {
            ds.setDriverClassName(addr);
        }
        if ((addr = this.getRefAddr(ref, JDBC_URL)) != null) {
            ds.setJdbcUrl(addr);
        }
        if ((binAddr = ref.get(PROPERTIES)) != null && (props = (Properties)DriverConnectionPoolDataSource.deserialize(data = (byte[])binAddr.getContent())) != null) {
            ds.setProperties(props);
        }
        return ds;
    }

    public Reference getDefaultReference() {
        Reference ref = super.getDefaultReference();
        if (this.getDriverClassName() != null) {
            ref.add(new StringRefAddr(DRIVER_CLASS_NAME, this.getDriverClassName()));
        }
        if (this.getJdbcUrl() != null) {
            ref.add(new StringRefAddr(JDBC_URL, this.getJdbcUrl()));
        }
        byte[] data = DriverConnectionPoolDataSource.serialize(this.getProperties());
        ref.add(new BinaryRefAddr(PROPERTIES, data));
        return ref;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DriverPooledConnectionManager
    implements PooledConnectionManager {
        private static final String USER_NAME_PROPERTY = "user";
        private static final String PASSWORD_PROPERTY = "password";
        private boolean driverInitialized;

        private DriverPooledConnectionManager() {
        }

        public PooledObject allocateConnection(Object key) throws SQLException {
            if (!this.driverInitialized) {
                try {
                    Class.forName(DriverConnectionPoolDataSource.this.getDriverClassName());
                    this.driverInitialized = true;
                }
                catch (ClassNotFoundException ex) {
                    throw new FBSQLException("Class " + DriverConnectionPoolDataSource.this.getDriverClassName() + " not found.");
                }
            }
            if (!(key instanceof AbstractConnectionPool.UserPasswordPair)) {
                throw new FBSQLException("Incorrect key.");
            }
            AbstractConnectionPool.UserPasswordPair pair = (AbstractConnectionPool.UserPasswordPair)key;
            String userName = pair.getUserName();
            String password = pair.getPassword();
            Properties props = new Properties();
            props.putAll((Map<?, ?>)DriverConnectionPoolDataSource.this.getProperties());
            if (userName != null) {
                props.setProperty(USER_NAME_PROPERTY, userName);
            }
            if (password != null) {
                props.setProperty(PASSWORD_PROPERTY, password);
            }
            Connection connection = DriverManager.getConnection(DriverConnectionPoolDataSource.this.getJdbcUrl(), props);
            PingablePooledConnection pooledConnection = null;
            pooledConnection = DriverConnectionPoolDataSource.this.isPingable() ? new PingablePooledConnection(connection, DriverConnectionPoolDataSource.this.getPingStatement(), DriverConnectionPoolDataSource.this.getPingInterval(), DriverConnectionPoolDataSource.this.isStatementPooling(), DriverConnectionPoolDataSource.this.getTransactionIsolationLevel(), DriverConnectionPoolDataSource.this.getMaxStatements(), DriverConnectionPoolDataSource.this.isKeepStatements()) : new PingablePooledConnection(connection, DriverConnectionPoolDataSource.this.isStatementPooling(), DriverConnectionPoolDataSource.this.getTransactionIsolationLevel(), DriverConnectionPoolDataSource.this.getMaxStatements(), DriverConnectionPoolDataSource.this.isKeepStatements());
            return pooledConnection;
        }
    }
}

