/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.field.FBField;

class FBShortField
extends FBField {
    FBShortField(XSQLVAR field, FBResultSet rs, int numCol, int requiredType) throws SQLException {
        super(field, rs, numCol, requiredType);
    }

    public byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Short value = new Short(this.field.decodeShort(this.rs.row[this.numCol]));
        if (value > 127 || value < -128) {
            throw (SQLException)FBShortField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    public short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        return this.field.decodeShort(this.rs.row[this.numCol]);
    }

    public int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        return this.field.decodeShort(this.rs.row[this.numCol]);
    }

    public long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        return this.field.decodeShort(this.rs.row[this.numCol]);
    }

    public float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        return this.field.decodeShort(this.rs.row[this.numCol]);
    }

    public double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return this.field.decodeShort(this.rs.row[this.numCol]);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return BigDecimal.valueOf(this.field.decodeShort(this.rs.row[this.numCol]));
    }

    public boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return this.field.decodeShort(this.rs.row[this.numCol]) == 1;
    }

    public String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeShort(this.rs.row[this.numCol]));
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setShort(Short.parseShort(value));
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBShortField.createException(SHORT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
    }

    public void setShort(short value) throws SQLException {
        this.field.sqldata = this.field.encodeShort(value);
    }

    public void setBoolean(boolean value) throws SQLException {
        this.setShort((short)(value ? 1 : 0));
    }

    public void setFloat(float value) throws SQLException {
        if (value > 32767.0f || value < -32768.0f) {
            throw (SQLException)FBShortField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    public void setDouble(double value) throws SQLException {
        if (value > 32767.0 || value < -32768.0) {
            throw (SQLException)FBShortField.createException(DOUBLE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    public void setLong(long value) throws SQLException {
        if (value > 32767L || value < -32768L) {
            throw (SQLException)FBShortField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    public void setInteger(int value) throws SQLException {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw (SQLException)FBShortField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    public void setByte(byte value) throws SQLException {
        this.setShort(value);
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(32767L)) > 0 || value.compareTo(BigDecimal.valueOf(-32768L)) < 0) {
            throw (SQLException)FBShortField.createException(BIGDECIMAL_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort(value.shortValue());
    }
}

