/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.field.FBField;

class FBLongField
extends FBField {
    FBLongField(XSQLVAR field, FBResultSet rs, int numCol, int requiredType) throws SQLException {
        super(field, rs, numCol, requiredType);
    }

    public byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Long value = new Long(this.field.decodeLong(this.rs.row[this.numCol]));
        if (value > 127L || value < -128L) {
            throw (SQLException)FBLongField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    public short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Long value = new Long(this.field.decodeLong(this.rs.row[this.numCol]));
        if (value > 32767L || value < -32768L) {
            throw (SQLException)FBLongField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    public int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Long value = new Long(this.field.decodeLong(this.rs.row[this.numCol]));
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw (SQLException)FBLongField.createException(INT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.intValue();
    }

    public long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        return this.field.decodeLong(this.rs.row[this.numCol]);
    }

    public float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        return this.field.decodeLong(this.rs.row[this.numCol]);
    }

    public double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return this.field.decodeLong(this.rs.row[this.numCol]);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return BigDecimal.valueOf(this.field.decodeLong(this.rs.row[this.numCol]));
    }

    public boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return this.field.decodeLong(this.rs.row[this.numCol]) == 1L;
    }

    public String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeLong(this.rs.row[this.numCol]));
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setLong(Long.parseLong(value));
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBLongField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
    }

    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    public void setBoolean(boolean value) throws SQLException {
        this.setLong(value ? 1L : 0L);
    }

    public void setFloat(float value) throws SQLException {
        if (value > 9.223372E18f || value < -9.223372E18f) {
            throw (SQLException)FBLongField.createException(FLOAT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setLong((long)value);
    }

    public void setDouble(double value) throws SQLException {
        if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            throw (SQLException)FBLongField.createException(DOUBLE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setLong((long)value);
    }

    public void setLong(long value) throws SQLException {
        this.field.sqldata = this.field.encodeLong(value);
    }

    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 || value.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
            throw (SQLException)FBLongField.createException(BIGDECIMAL_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setLong(value.longValue());
    }
}

