/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.field.FBField;

class FBIntegerField
extends FBField {
    FBIntegerField(XSQLVAR field, FBResultSet rs, int numCol, int requiredType) throws SQLException {
        super(field, rs, numCol, requiredType);
    }

    public byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Integer value = new Integer(this.field.decodeInt(this.rs.row[this.numCol]));
        if (value > 127 || value < -128) {
            throw (SQLException)FBIntegerField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    public short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Integer value = new Integer(this.field.decodeInt(this.rs.row[this.numCol]));
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw (SQLException)FBIntegerField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    public int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        return this.field.decodeInt(this.rs.row[this.numCol]);
    }

    public long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        return this.field.decodeInt(this.rs.row[this.numCol]);
    }

    public float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        return this.field.decodeInt(this.rs.row[this.numCol]);
    }

    public double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return this.field.decodeInt(this.rs.row[this.numCol]);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return BigDecimal.valueOf(this.field.decodeInt(this.rs.row[this.numCol]));
    }

    public boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return this.field.decodeInt(this.rs.row[this.numCol]) == 1;
    }

    public String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeInt(this.rs.row[this.numCol]));
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setInteger(Integer.parseInt(value));
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBIntegerField.createException(INT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
    }

    public void setShort(short value) throws SQLException {
        this.setInteger(value);
    }

    public void setBoolean(boolean value) throws SQLException {
        this.setInteger(value ? 1 : 0);
    }

    public void setFloat(float value) throws SQLException {
        if (value > 2.1474836E9f || value < -2.1474836E9f) {
            throw (SQLException)FBIntegerField.createException(FLOAT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setInteger((int)value);
    }

    public void setDouble(double value) throws SQLException {
        if (value > 2.147483647E9 || value < -2.147483648E9) {
            throw (SQLException)FBIntegerField.createException(DOUBLE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setInteger((int)value);
    }

    public void setLong(long value) throws SQLException {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw (SQLException)FBIntegerField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setInteger((int)value);
    }

    public void setInteger(int value) throws SQLException {
        this.field.sqldata = this.field.encodeInt(value);
    }

    public void setByte(byte value) throws SQLException {
        this.setInteger(value);
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0 || value.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) < 0) {
            throw (SQLException)FBIntegerField.createException(BIGDECIMAL_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setInteger(value.intValue());
    }
}

