/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSType;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBTpbMapper;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBDriver
implements Driver {
    private static final Logger log;
    public static final String FIREBIRD_PROTOCOL = "jdbc:firebirdsql:";
    public static final String FIREBIRD_PROTOCOL_NATIVE = "jdbc:firebirdsql:native:";
    public static final String FIREBIRD_PROTOCOL_NATIVE_EMBEDDED = "jdbc:firebirdsql:embedded";
    public static final String FIREBIRD_PROTOCOL_NATIVE_LOCAL = "jdbc:firebirdsql:local:";
    public static final String FIREBIRD_PROTOCOL_ORACLE_MODE = "jdbc:firebirdsql:oracle:";
    public static final String CHARSET = "charSet";
    public static final String USE_TRANSLATION = "useTranslation";
    public static final String USER = "user";
    public static final String USER_NAME = "user_name";
    public static final String PASSWORD = "password";
    public static final String DATABASE = "database";
    public static final String BLOB_BUFFER_LENGTH = "blob_buffer_length";
    public static final String TPB_MAPPING = "tpb_mapping";
    private Map mcfToDataSourceMap = new HashMap();
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBDriver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || !url.startsWith(FIREBIRD_PROTOCOL)) {
            return null;
        }
        GDSType type = this.getDriverType(url);
        try {
            if (info == null) {
                info = new Properties();
            }
            info = FBDriverPropertyManager.normalize(url, info);
            int qMarkIndex = url.indexOf(63);
            if (qMarkIndex != -1) {
                url = url.substring(0, qMarkIndex);
            }
            Integer blobBufferLength = this.extractBlobBufferLength(info);
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            FBConnectionRequestInfo conCri = FBConnectionHelper.getCri(info, mcf.getDefaultConnectionRequestInfo());
            FBTpbMapper tpbMapper = FBConnectionHelper.getTpbMapper(info);
            String user = conCri.getStringProperty(28);
            if (user == null) {
                user = conCri.getStringProperty(28);
            }
            if (user == null) {
                throw new FBSQLException("User for database connection not specified.", "01S00");
            }
            String password = info.getProperty(PASSWORD);
            if (password == null) {
                password = conCri.getStringProperty(29);
            }
            if (password == null) {
                throw new FBSQLException("Password for database connection not specified.", "01S00");
            }
            String databaseURL = url.startsWith(FIREBIRD_PROTOCOL_NATIVE) ? url.substring(FIREBIRD_PROTOCOL_NATIVE.length()) : (url.startsWith(FIREBIRD_PROTOCOL_NATIVE_EMBEDDED) ? url.substring(FIREBIRD_PROTOCOL_NATIVE_EMBEDDED.length() + 1) : (url.startsWith(FIREBIRD_PROTOCOL_NATIVE_LOCAL) ? url.substring(FIREBIRD_PROTOCOL_NATIVE_LOCAL.length()) : (url.startsWith(FIREBIRD_PROTOCOL_ORACLE_MODE) ? url.substring(FIREBIRD_PROTOCOL_ORACLE_MODE.length()) : url.substring(FIREBIRD_PROTOCOL.length()))));
            mcf.setDatabase(databaseURL);
            mcf.setConnectionRequestInfo(conCri);
            if (tpbMapper != null) {
                mcf.setTpbMapper(tpbMapper);
            }
            if (blobBufferLength != null) {
                mcf.setBlobBufferLength(blobBufferLength);
            }
            mcf = mcf.canonicalize();
            FBDataSource dataSource = null;
            Map map = this.mcfToDataSourceMap;
            synchronized (map) {
                dataSource = (FBDataSource)this.mcfToDataSourceMap.get(mcf);
                if (dataSource == null) {
                    dataSource = (FBDataSource)mcf.createConnectionFactory();
                    this.mcfToDataSourceMap.put(mcf, dataSource);
                }
            }
            return dataSource.getConnection(user, password);
        }
        catch (ResourceException resex) {
            throw new FBSQLException(resex);
        }
    }

    private Integer extractBlobBufferLength(Properties info) throws SQLException {
        String blobBufferLengthStr = (String)info.get("isc_dpb_blob_buffer_length");
        if (blobBufferLengthStr == null) {
            return null;
        }
        try {
            return new Integer(blobBufferLengthStr);
        }
        catch (NumberFormatException e) {
            throw new FBSQLException("Blob buffer length " + blobBufferLengthStr + " could not be converted to an integer", "01S00");
        }
    }

    private GDSType getDriverType(String url) {
        if (url.startsWith(FIREBIRD_PROTOCOL_NATIVE)) {
            return GDSType.NATIVE;
        }
        if (url.startsWith(FIREBIRD_PROTOCOL_NATIVE_EMBEDDED)) {
            return GDSType.NATIVE_EMBEDDED;
        }
        if (url.startsWith(FIREBIRD_PROTOCOL_NATIVE_LOCAL)) {
            return GDSType.NATIVE_LOCAL;
        }
        if (url.startsWith(FIREBIRD_PROTOCOL_ORACLE_MODE)) {
            return GDSType.ORACLE_MODE;
        }
        return GDSType.PURE_JAVA;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(FIREBIRD_PROTOCOL);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return FBDriverPropertyManager.getDriverPropertyInfo(info);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 5;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBDriver == null ? (class$org$firebirdsql$jdbc$FBDriver = FBDriver.class$("org.firebirdsql.jdbc.FBDriver")) : class$org$firebirdsql$jdbc$FBDriver, false);
            try {
                DriverManager.registerDriver(new FBDriver());
            }
            catch (Exception ex) {
                if (log == null) break block2;
                log.error("Could not register with driver manager", ex);
            }
        }
    }
}

