/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBBlobField;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBLongVarCharField;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FBCachedFetcher
implements FBFetcher {
    private boolean forwardOnly;
    private Object[] rowsArray;
    private AbstractStatement fbStatement;
    private FBResultSet rs;
    private int rowNum = 0;
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBCachedFetcher == null ? (class$org$firebirdsql$jdbc$FBCachedFetcher = FBCachedFetcher.class$("org.firebirdsql.jdbc.FBCachedFetcher")) : class$org$firebirdsql$jdbc$FBCachedFetcher, false);
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBCachedFetcher;

    FBCachedFetcher(AbstractConnection c, AbstractStatement fbStatement, isc_stmt_handle stmt_handle, FBResultSet rs) throws SQLException {
        this.forwardOnly = rs.getType() == 1003;
        ArrayList<Object[]> rowsSets = new ArrayList<Object[]>(100);
        ArrayList rows = new ArrayList(100);
        isc_stmt_handle stmt = stmt_handle;
        byte[][] localRow = null;
        this.fbStatement = fbStatement;
        this.rs = rs;
        boolean[] isBlob = new boolean[rs.xsqlvars.length];
        boolean hasBlobs = false;
        for (int i = 0; i < rs.xsqlvars.length; ++i) {
            boolean bl = isBlob[i] = FBField.isType(rs.xsqlvars[i], 2004) || FBField.isType(rs.xsqlvars[i], -2) || FBField.isType(rs.xsqlvars[i], -1);
            if (!isBlob[i]) continue;
            hasBlobs = true;
        }
        int rowsCount = 0;
        try {
            int fetchSize = fbStatement.fetchSize;
            if (fetchSize == 0) {
                fetchSize = 400;
            }
            if (!stmt.getAllRowsFetched() && stmt.size() == 0) {
                do {
                    if (fbStatement.maxRows != 0 && fetchSize > fbStatement.maxRows - stmt.size()) {
                        fetchSize = fbStatement.maxRows - stmt.size();
                    }
                    c.fetch(stmt, fetchSize);
                    if (stmt.size() <= 0) continue;
                    rowsSets.add(stmt.getRows());
                    rowsCount += stmt.size();
                    stmt.removeRows();
                } while (!stmt.getAllRowsFetched() && (fbStatement.maxRows == 0 || rowsCount < fbStatement.maxRows));
                int rowCount = 0;
                this.rowsArray = new Object[rowsCount];
                for (int i = 0; i < rowsSets.size(); ++i) {
                    Object[] oneSet = (Object[])rowsSets.get(i);
                    if (oneSet.length > rowsCount - rowCount) {
                        System.arraycopy(oneSet, 0, this.rowsArray, rowCount, rowsCount - rowCount);
                        rowCount = rowsCount;
                        continue;
                    }
                    System.arraycopy(oneSet, 0, this.rowsArray, rowCount, oneSet.length);
                    rowCount += oneSet.length;
                }
                rowsSets.clear();
            } else {
                this.rowsArray = stmt.getRows();
                stmt.removeRows();
            }
            if (hasBlobs) {
                for (int i = 0; i < this.rowsArray.length; ++i) {
                    localRow = (byte[][])this.rowsArray[i];
                    for (int j = 0; j < localRow.length; ++j) {
                        if (!isBlob[j] || localRow[j] == null) continue;
                        rs.row = localRow;
                        FBField localField = FBField.createField(rs.xsqlvars[j], rs, j, false);
                        FBFlushableField blob = (FBFlushableField)((Object)localField);
                        if (blob instanceof FBBlobField) {
                            ((FBBlobField)blob).setConnection(c);
                        } else if (blob instanceof FBLongVarCharField) {
                            ((FBLongVarCharField)blob).setConnection(c);
                        }
                        localRow[j] = blob.getCachedObject();
                        rs.row = null;
                    }
                }
            }
            c.closeStatement(stmt, false);
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    FBCachedFetcher(ArrayList rows, FBResultSet rs) throws SQLException {
        this.rowsArray = rows.toArray();
        this.rs = rs;
    }

    public boolean next() throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        ++this.rowNum;
        if (this.isAfterLast()) {
            this.rs.row = null;
            this.rowNum = this.rowsArray.length + 1;
            return false;
        }
        this.rs.row = (byte[][])this.rowsArray[this.rowNum - 1];
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        if (this.isEmpty()) {
            return false;
        }
        --this.rowNum;
        if (this.isBeforeFirst()) {
            this.rs.row = null;
            this.rowNum = 0;
            return false;
        }
        this.rs.row = (byte[][])this.rowsArray[this.rowNum - 1];
        return true;
    }

    public boolean absolute(int row) throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(row, false);
    }

    private boolean absolute(int row, boolean internal) throws SQLException {
        if (this.forwardOnly && !internal) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        if (row < 0) {
            row = this.rowsArray.length + row + 1;
        }
        if (row == 0 && !internal) {
            throw new FBSQLException("You cannot position to the row 0 with absolute() method.");
        }
        if (this.isEmpty()) {
            return false;
        }
        this.rowNum = row;
        if (this.isBeforeFirst()) {
            this.rs.row = null;
            this.rowNum = 0;
            return false;
        }
        if (this.isAfterLast()) {
            this.rs.row = null;
            this.rowNum = this.rowsArray.length + 1;
            return false;
        }
        this.rs.row = (byte[][])this.rowsArray[this.rowNum - 1];
        return true;
    }

    public boolean first() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(1, true);
    }

    public boolean last() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(-1, true);
    }

    public boolean relative(int row) throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(this.rowNum + row, true);
    }

    public void beforeFirst() throws SQLException {
        this.first();
        this.previous();
    }

    public void afterLast() throws SQLException {
        this.last();
        this.next();
    }

    public void close() throws SQLException {
    }

    public AbstractStatement getStatement() {
        return this.fbStatement;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public boolean isEmpty() {
        return this.rowsArray == null || this.rowsArray.length == 0;
    }

    public boolean isBeforeFirst() {
        return !this.isEmpty() && this.rowNum < 1;
    }

    public boolean isFirst() {
        return this.rowNum == 1;
    }

    public boolean isLast() {
        return this.rowsArray != null ? this.rowNum == this.rowsArray.length : false;
    }

    public boolean isAfterLast() {
        return this.rowNum > this.rowsArray.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

