/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.gds.isc_tr_handle;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBManagedConnectionMetaData;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXAException;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBManagedConnection
implements ManagedConnection,
XAResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass(), false);
    private FBManagedConnectionFactory mcf;
    private ArrayList connectionEventListeners = new ArrayList();
    private ArrayList connectionHandles = new ArrayList();
    private int timeout = 0;
    protected FBConnectionRequestInfo cri;
    private isc_tr_handle currentTr;
    private isc_db_handle currentDbHandle;
    public boolean autoCommit = true;
    private final FBTpb tpb;
    private static final String RECOVERY_QUERY = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE = 1";
    static final CELNotifier connectionClosedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionClosed(ce);
        }
    };
    static final CELNotifier connectionErrorOccurredNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionErrorOccurred(ce);
        }
    };
    static final CELNotifier localTransactionStartedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionStarted(ce);
        }
    };
    static final CELNotifier localTransactionCommittedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionCommitted(ce);
        }
    };
    static final CELNotifier localTransactionRolledbackNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionRolledback(ce);
        }
    };

    FBManagedConnection(Subject subject, ConnectionRequestInfo cri, FBManagedConnectionFactory mcf) throws ResourceException {
        this.mcf = mcf;
        this.cri = this.getCombinedConnectionRequestInfo(subject, cri);
        this.tpb = mcf.getTpb();
        try {
            this.currentDbHandle = mcf.createDbHandle(this.cri);
        }
        catch (GDSException ge) {
            if (this.log != null) {
                this.log.debug("Could not get a db connection!", ge);
            }
            throw new FBResourceException(ge);
        }
    }

    public LocalTransaction getLocalTransaction() {
        return new FBLocalTransaction(this, null);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new FBManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter out) {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        try {
            ((AbstractConnection)connection).setManagedConnection(this);
            this.connectionHandles.add(connection);
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("invalid connection supplied to associateConnection.", cce);
        }
    }

    public void cleanup() throws ResourceException {
        Iterator i = this.connectionHandles.iterator();
        while (i.hasNext()) {
            ((AbstractConnection)i.next()).setManagedConnection(null);
        }
        this.connectionHandles.clear();
        this.currentTr = null;
        this.tpb.setTpb(this.mcf.getTpb());
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (!this.matches(subject, cri)) {
            throw new FBResourceException("Incompatible subject or ConnectionRequestInfo in getConnection!");
        }
        FBConnection c = new FBConnection(this);
        this.connectionHandles.add(c);
        return c;
    }

    public void destroy() throws ResourceException {
        if (this.currentTr != null) {
            throw new IllegalStateException("Can't destroy managed connection  with active transaction");
        }
        if (this.currentDbHandle != null) {
            try {
                this.mcf.releaseDbHandle(this.currentDbHandle, this.cri);
            }
            catch (GDSException ge) {
                throw new FBResourceException("Can't detach from db.", ge);
            }
            finally {
                this.currentDbHandle = null;
            }
        }
    }

    public XAResource getXAResource() {
        if (this.log != null) {
            this.log.debug("XAResource requested from FBManagedConnection");
        }
        return this;
    }

    boolean isXidActive(Xid xid) {
        isc_tr_handle trHandle = this.mcf.getTrHandleForXid(xid);
        if (trHandle == null) {
            return false;
        }
        isc_db_handle dbHandle = trHandle.getDbHandle();
        if (dbHandle == null) {
            return false;
        }
        return dbHandle.isValid();
    }

    public void commit(Xid id, boolean twoPhase) throws XAException {
        try {
            this.internalCommit(id, twoPhase);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    void internalCommit(Xid id, boolean twoPhase) throws XAException, GDSException {
        isc_tr_handle committingTr;
        if (this.log != null) {
            this.log.debug("Commit called: " + id);
        }
        if ((committingTr = this.mcf.getTrHandleForXid(id)) == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        if (committingTr == this.currentTr) {
            throw new FBXAException("Commit called with current xid", -6);
        }
        isc_db_handle committingDbHandle = committingTr.getDbHandle();
        try {
            this.mcf.commit(id);
        }
        catch (GDSException ge) {
            this.checkFatalXA(ge, committingDbHandle);
            if (this.log != null) {
                this.log.debug("Fatal error committing, ", ge);
            }
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    public void end(Xid id, int flags) throws XAException {
        this.internalEnd(id, flags);
    }

    void internalEnd(Xid id, int flags) throws XAException {
        isc_tr_handle endingTr;
        if (flags != 0x2000000 && flags != 0x4000000 && flags != 0x20000000) {
            throw new FBXAException("Invalid flag in end: must be TMSUSPEND, TMSUCCESS, or TMFAIL", -5);
        }
        if (this.log != null) {
            this.log.debug("End called: " + id);
        }
        if ((endingTr = this.mcf.getTrHandleForXid(id)) == null) {
            throw new FBXAException("Unrecognized transaction", -4);
        }
        if (endingTr == this.currentTr) {
            this.currentTr = null;
        } else if (flags == 0x2000000) {
            throw new FBXAException("You are trying to suspend a transaction that is not the current transaction", -5);
        }
    }

    public void forget(Xid id) throws XAException {
        throw new FBXAException("Not yet implemented");
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    public boolean isSameRM(XAResource res) throws XAException {
        return res instanceof FBManagedConnection && this.mcf == ((FBManagedConnection)res).mcf;
    }

    public int prepare(Xid id) throws XAException {
        isc_tr_handle committingTr;
        if (this.log != null) {
            this.log.debug("prepare called: " + id);
        }
        if ((committingTr = this.mcf.getTrHandleForXid(id)) == null) {
            throw new FBXAException("Prepare called with unknown transaction", -5);
        }
        if (committingTr == this.currentTr) {
            throw new FBXAException("Prepare called with current xid", -6);
        }
        isc_db_handle committingDbHandle = committingTr.getDbHandle();
        try {
            this.mcf.prepare(id);
        }
        catch (GDSException ge) {
            this.checkFatalXA(ge, committingDbHandle);
            if (this.log != null) {
                this.log.debug("Exception in prepare", ge);
            }
            throw new FBXAException(-3, ge);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        Xid[] xidArray;
        ArrayList<FBXid> xids = new ArrayList<FBXid>();
        Connection conn = null;
        conn = (Connection)this.getConnection(null, null);
        try {
            Statement statement = conn.createStatement();
            ResultSet recoveredRS = statement.executeQuery(RECOVERY_QUERY);
            while (recoveredRS.next()) {
                try {
                    long transactionID = recoveredRS.getLong(1);
                    InputStream xidIn = recoveredRS.getBinaryStream(2);
                    FBXid xid = new FBXid(xidIn);
                    xids.add(xid);
                }
                catch (SQLException sqle) {
                }
                catch (ResourceException sqle) {}
            }
            xidArray = xids.toArray(new Xid[xids.size()]);
        }
        catch (Throwable throwable) {
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                if (this.log != null) {
                    this.log.debug("can't perform query to fetch xids", sqle);
                }
                throw new XAException(-7);
            }
            catch (ResourceException re) {
                if (this.log != null) {
                    this.log.debug("can't perform query to fetch xids", re);
                }
                throw new XAException(-7);
            }
        }
        conn.close();
        return xidArray;
    }

    public void rollback(Xid id) throws XAException {
        try {
            this.internalRollback(id);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    void internalRollback(Xid id) throws XAException, GDSException {
        isc_tr_handle committingTr;
        if (this.log != null) {
            this.log.debug("rollback called: " + id);
        }
        if ((committingTr = this.mcf.getTrHandleForXid(id)) == null) {
            if (this.log != null) {
                this.log.warn("rollback called with unknown transaction: " + id);
            }
            return;
        }
        if (committingTr == this.currentTr) {
            throw new FBXAException("Rollback called with current xid", -6);
        }
        isc_db_handle committingDbHandle = committingTr.getDbHandle();
        try {
            this.mcf.rollback(id);
        }
        catch (GDSException ge) {
            this.checkFatalXA(ge, committingDbHandle);
            if (this.log != null) {
                this.log.debug("Exception in rollback", ge);
            }
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    public void start(Xid id, int flags) throws XAException {
        try {
            this.internalStart(id, flags);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    public void internalStart(Xid id, int flags) throws XAException, GDSException {
        if (this.log != null) {
            this.log.debug("start called: " + id);
        }
        if (this.currentTr != null) {
            throw new XAException(-6);
        }
        this.findIscTrHandle(id, flags);
    }

    private void checkFatalXA(GDSException ge, isc_db_handle committingDbHandle) {
        if (ge.isFatal()) {
            this.mcf.destroyDbHandle(committingDbHandle, this.cri);
            if (this.currentDbHandle == committingDbHandle) {
                this.currentTr = null;
                ConnectionEvent ce = new ConnectionEvent(this, 5, ge);
                this.notify(connectionErrorOccurredNotifier, ce);
            }
        }
    }

    private void checkFatal(GDSException ge) {
        if (ge.isFatal()) {
            this.mcf.destroyDbHandle(this.currentDbHandle, this.cri);
            this.currentTr = null;
            ConnectionEvent ce = new ConnectionEvent(this, 5, ge);
            this.notify(connectionErrorOccurredNotifier, ce);
        }
    }

    public isc_stmt_handle getAllocatedStatement() throws GDSException {
        if (this.currentTr == null) {
            throw new GDSException("No transaction started for allocate statement");
        }
        isc_stmt_handle stmt = this.mcf.gds.get_new_isc_stmt_handle();
        try {
            this.mcf.gds.isc_dsql_allocate_statement(this.currentTr.getDbHandle(), stmt);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
        return stmt;
    }

    public boolean inTransaction() {
        return this.currentTr != null;
    }

    public void prepareSQL(isc_stmt_handle stmt, String sql, boolean describeBind) throws GDSException, SQLException {
        if (this.log != null) {
            this.log.debug("preparing sql: " + sql);
        }
        String localEncoding = this.cri.getStringProperty(135);
        String mappingPath = this.cri.getStringProperty(136);
        Encoding encoding = EncodingFactory.getEncoding(localEncoding, mappingPath);
        int dialect = 3;
        if (this.cri.hasArgument(63)) {
            dialect = this.cri.getIntProperty(63);
        }
        try {
            XSQLDA out = this.mcf.gds.isc_dsql_prepare(this.currentTr, stmt, encoding.encodeToCharset(sql), dialect);
            if (out.sqld != out.sqln) {
                throw new GDSException("Not all columns returned");
            }
            if (describeBind) {
                this.mcf.gds.isc_dsql_describe_bind(stmt, 1);
            }
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void executeStatement(isc_stmt_handle stmt, boolean sendOutSqlda) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_execute2(this.currentTr, stmt, 1, stmt.getInSqlda(), sendOutSqlda ? stmt.getOutSqlda() : null);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void executeImmediate(String statement) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_exec_immed2(this.getIscDBHandle(), this.currentTr, statement, 3, null, null);
        }
        catch (GDSException ex) {
            this.checkFatal(ex);
            throw ex;
        }
    }

    public void fetch(isc_stmt_handle stmt, int fetchSize) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_fetch(stmt, 1, stmt.getOutSqlda(), fetchSize);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void setCursorName(isc_stmt_handle stmt, String cursorName) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_set_cursor_name(stmt, cursorName, 0);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void closeStatement(isc_stmt_handle stmt, boolean deallocate) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_free_statement(stmt, deallocate ? 2 : 1);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void close(AbstractConnection c) {
        c.setManagedConnection(null);
        this.connectionHandles.remove(c);
        ConnectionEvent ce = new ConnectionEvent(this, 1, null);
        ce.setConnectionHandle(c);
        this.notify(connectionClosedNotifier, ce);
    }

    public void registerStatement(isc_stmt_handle fbStatement) {
        if (this.currentTr == null) {
            throw new IllegalStateException("registerStatement called with no transaction");
        }
        this.currentTr.registerStatementWithTransaction(fbStatement);
    }

    public isc_blob_handle openBlobHandle(long blob_id, boolean segmented) throws GDSException {
        try {
            isc_blob_handle blob = this.mcf.gds.get_new_isc_blob_handle();
            blob.setBlob_id(blob_id);
            BlobParameterBuffer blobParameterBuffer = this.mcf.gds.newBlobParameterBuffer();
            blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
            this.mcf.gds.isc_open_blob2(this.currentDbHandle, this.currentTr, blob, blobParameterBuffer);
            return blob;
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public isc_blob_handle createBlobHandle(boolean segmented) throws GDSException {
        try {
            isc_blob_handle blob = this.mcf.gds.get_new_isc_blob_handle();
            BlobParameterBuffer blobParameterBuffer = this.mcf.gds.newBlobParameterBuffer();
            blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
            this.mcf.gds.isc_create_blob2(this.currentDbHandle, this.currentTr, blob, blobParameterBuffer);
            return blob;
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public byte[] getBlobSegment(isc_blob_handle blob, int len) throws GDSException {
        try {
            return this.mcf.gds.isc_get_segment(blob, len);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void closeBlob(isc_blob_handle blob) throws GDSException {
        try {
            this.mcf.gds.isc_close_blob(blob);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void putBlobSegment(isc_blob_handle blob, byte[] buf) throws GDSException {
        try {
            this.mcf.gds.isc_put_segment(blob, buf);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void getSqlCounts(isc_stmt_handle stmt) throws GDSException {
        try {
            this.mcf.gds.getSqlCounts(stmt);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public String getDatabaseProductName() {
        return this.currentDbHandle.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return this.currentDbHandle.getDatabaseProductVersion();
    }

    public int getDatabaseProductMajorVersion() {
        return this.currentDbHandle.getDatabaseProductMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.currentDbHandle.getDatabaseProductMinorVersion();
    }

    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    public String getUserName() {
        return this.cri.getUser();
    }

    public int getTransactionIsolation() throws ResourceException {
        return this.tpb.getTransactionIsolation();
    }

    public void setTransactionIsolation(int isolation) throws ResourceException {
        this.tpb.setTransactionIsolation(isolation);
    }

    public String getTransactionIsolationName() throws ResourceException {
        return this.tpb.getTransactionIsolationName();
    }

    public void setTransactionIsolationName(String isolation) throws ResourceException {
        this.tpb.setTransactionIsolationName(isolation);
    }

    public int getIscTransactionIsolation() throws ResourceException {
        return this.tpb.getIscTransactionIsolation();
    }

    public void setIscTransactionIsolation(int isolation) throws ResourceException {
        this.tpb.setIscTransactionIsolation(isolation);
    }

    public void setReadOnly(boolean readOnly) {
        this.tpb.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.tpb.isReadOnly();
    }

    public Integer getBlobBufferLength() {
        return this.mcf.getBlobBufferLength();
    }

    public String getIscEncoding() {
        try {
            String result = this.cri.getStringProperty(48);
            if (result == null) {
                result = "NONE";
            }
            return result;
        }
        catch (NullPointerException ex) {
            return "NONE";
        }
    }

    public List getWarnings() {
        if (this.currentDbHandle == null) {
            return Collections.EMPTY_LIST;
        }
        return this.currentDbHandle.getWarnings();
    }

    public void clearWarnings() {
        if (this.currentDbHandle != null) {
            this.currentDbHandle.clearWarnings();
        }
    }

    public isc_db_handle getIscDBHandle() throws GDSException {
        if (this.currentDbHandle == null) {
            this.currentDbHandle = this.mcf.getDbHandle(this.cri);
        }
        return this.currentDbHandle;
    }

    public GDS getInternalAPIHandler() {
        return this.mcf.gds;
    }

    public FBConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    private void findIscTrHandle(Xid xid, int flags) throws GDSException, XAException {
        try {
            this.currentTr = this.mcf.getCurrentIscTrHandle(xid, this, flags);
        }
        catch (GDSException ge) {
            block8: {
                this.currentTr = null;
                if (this.currentDbHandle != null && this.currentDbHandle.isValid()) {
                    try {
                        this.mcf.returnDbHandle(this.currentDbHandle, this.cri);
                    }
                    catch (GDSException ge2) {
                        if (this.log == null) break block8;
                        this.log.debug("Another exception killing a dead connection", ge2);
                    }
                }
            }
            ConnectionEvent ce = new ConnectionEvent(this, 5, ge);
            this.notify(connectionErrorOccurredNotifier, ce);
            ge.setXAErrorCode(-3);
            throw ge;
        }
        if (this.currentTr.getDbHandle() != this.currentDbHandle) {
            try {
                this.mcf.returnDbHandle(this.currentDbHandle, this.cri);
            }
            catch (GDSException ge) {
                ge.setXAErrorCode(-3);
                throw ge;
            }
            this.currentDbHandle = this.currentTr.getDbHandle();
        }
    }

    isc_db_handle getIscDBHandle(Set reserved) throws GDSException {
        if (this.currentDbHandle == null) {
            this.currentDbHandle = this.mcf.getDbHandle(this.cri);
        } else if (reserved.contains(this.currentDbHandle)) {
            this.mcf.releaseDbHandle(this.currentDbHandle, this.cri);
            this.currentDbHandle = this.mcf.getDbHandle(this.cri);
        }
        return this.currentDbHandle;
    }

    void notify(CELNotifier notifier, ConnectionEvent ce) {
        if (this.connectionEventListeners.size() == 0) {
            return;
        }
        if (this.connectionEventListeners.size() == 1) {
            ConnectionEventListener cel = (ConnectionEventListener)this.connectionEventListeners.get(0);
            notifier.notify(cel, ce);
            return;
        }
        ArrayList cels = (ArrayList)this.connectionEventListeners.clone();
        Iterator i = cels.iterator();
        while (i.hasNext()) {
            notifier.notify((ConnectionEventListener)i.next(), ce);
        }
    }

    boolean matches(Subject subj, ConnectionRequestInfo cri) {
        try {
            return this.cri.equals(this.getCombinedConnectionRequestInfo(subj, cri));
        }
        catch (ResourceException re) {
            return false;
        }
    }

    public FBTpb getTpb() {
        return this.tpb;
    }

    private FBConnectionRequestInfo getCombinedConnectionRequestInfo(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri == null) {
            cri = this.mcf.getDefaultConnectionRequestInfo();
        }
        try {
            FBConnectionRequestInfo fbcri = (FBConnectionRequestInfo)cri;
            if (subject != null) {
                Iterator<Object> i = subject.getPrivateCredentials().iterator();
                while (i.hasNext()) {
                    Object cred = i.next();
                    if (!(cred instanceof PasswordCredential) || !this.mcf.equals(((PasswordCredential)cred).getManagedConnectionFactory())) continue;
                    PasswordCredential pcred = (PasswordCredential)cred;
                    String user = pcred.getUserName();
                    String password = new String(pcred.getPassword());
                    fbcri.setPassword(password);
                    fbcri.setUser(user);
                    break;
                }
            }
            return fbcri;
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("Incorrect ConnectionRequestInfo class supplied");
        }
    }

    static interface CELNotifier {
        public void notify(ConnectionEventListener var1, ConnectionEvent var2);
    }
}

