drop table pontuacao;
drop table criterio;
drop table historico;
drop table operador_portfolio;
drop table avaliacao;
drop table operador;
drop table alocacao_projeto_recurso;
drop table projeto;
drop table recurso;
drop table portfolio;

CREATE TABLE portfolio(
    id INTEGER NOT NULL,
    nome VARCHAR(30) NOT NULL,
    CONSTRAINT id_pk
        PRIMARY KEY(id)
);

CREATE TABLE recurso(
    id INTEGER NOT NULL,
    id_portfolio INTEGER NOT NULL,
    nome varchar(30) NOT NULL,
    status varchar(10) not null,
    categoria varchar(10) not null,
    CONSTRAINT recurso_pk
        PRIMARY KEY(id),
    CONSTRAINT recurso_fk
        FOREIGN KEY(id_portfolio) references portfolio(id)
);

create table projeto(id INTEGER not null,
 id_portfolio INTEGER not null,
 nome VARCHAR(30) not null,
 descricao VARCHAR(100),
 inicio DATE not null,
 termino DATE not null,
 CONSTRAINT projeto_pk
     PRIMARY KEY(id),
 CONSTRAINT projeto_fk
     FOREIGN KEY(id_portfolio) references portfolio(id)
);

create table alocacao_projeto_recurso(
 id_recurso INTEGER not null,
 id_projeto INTEGER not null,
 CONSTRAINT alocacao_pk
    PRIMARY KEY(id_recurso, id_projeto),
 CONSTRAINT alocacao_fk1
    FOREIGN KEY(id_projeto) references projeto(id),
 CONSTRAINT alocacao_fk2
    FOREIGN KEY(id_recurso) references recurso(id)
);

create table operador(
 cpf varchar(14) not null,
 nome varchar(100) not null,
 email varchar(100) not null,
 telefone varchar(13) not null,
 constraint operador_pk
   primary key(cpf)
);

create table avaliacao(
 id INTEGER not null,
 total NUMBER(5,2) not null,
 data DATE not null,
 id_projeto INTEGER not null,
 cpf_operador VARCHAR(14) not null,
 CONSTRAINT avaliacao_pk
    PRIMARY KEY(id),
 CONSTRAINT avaliacao_fk1
    FOREIGN KEY(id_projeto) references projeto(id),
 CONSTRAINT avaliacao_fk2
    FOREIGN KEY(cpf_operador) references operador(cpf)
);

create table operador_portfolio(
 cpf_operador VARCHAR(14) not null,
 id_portfolio INTEGER not null,
 CONSTRAINT op_ptf_pk
    PRIMARY KEY(cpf_operador, id_portfolio),
 CONSTRAINT op_ptf_fk1
    FOREIGN KEY(cpf_operador) references operador(cpf),
 CONSTRAINT op_ptf_fk2
    FOREIGN KEY(id_portfolio) references portfolio(id)
);

create table historico(
 id INTEGER not null,
 data TIMESTAMP not null,
 valor VARCHAR(50) not null,
 id_portfolio INTEGER not null,
 id_projeto INTEGER not null,
 CONSTRAINT historico_pk
    PRIMARY KEY(id),
 CONSTRAINT historico_fk1
    FOREIGN KEY(id_projeto) references projeto(id),
 CONSTRAINT historico_fk2
    FOREIGN KEY(id_portfolio) references portfolio(id)
);

create table criterio(
 id INTEGER not null,
 peso NUMBER(3,2) not null,
 nome VARCHAR(50) not null,
 descricao VARCHAR(100),
 id_portfolio INTEGER not null,
 CONSTRAINT criterio_pk
    PRIMARY KEY(id),
 CONSTRAINT criterio_fk2
    FOREIGN KEY(id_portfolio) references portfolio(id)
);

create table pontuacao(
 id_criterio INTEGER not null,
 id_avaliacao INTEGER not null,
 nota NUMBER(3,2) not null,
 CONSTRAINT pontuacao_pk
    PRIMARY KEY(id_criterio, id_avaliacao),
 CONSTRAINT pontuacao_fk1
    FOREIGN KEY(id_criterio) references criterio(id),
 CONSTRAINT pontuacao_fk2
    FOREIGN KEY(id_avaliacao) references avaliacao(id)
);

create table projeto_portfolio(
  id_projeto INTEGER not null,
  id_portfolio INTEGER not null,
    CONSTRAINT pj_port_pk
    PRIMARY KEY(id_projeto, id_portfolio),
 CONSTRAINT pj_port_fk1
    FOREIGN KEY(id_projeto) references projeto(id),
 CONSTRAINT pj_port_fk2
    FOREIGN KEY(id_portfolio) references portfolio(id)
);

