/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.foundation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.xjlib.foundation.XJSystem;

public class XJUtils {
    public static final String VERSION_EA = "ea";
    public static final String VERSION_BETA = "b";

    public static String concatPath(String string, String string2, String string3) {
        if (string.endsWith(string3) && string2.startsWith(string3)) {
            return string + string2.substring(1);
        }
        if (string.endsWith(string3)) {
            return string + string2;
        }
        if (string2.startsWith(string3)) {
            return string + string2;
        }
        return string + string3 + string2;
    }

    public static String concatPath(String string, String string2) {
        return XJUtils.concatPath(string, string2, File.separator);
    }

    public static String getLastPathComponent(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(File.separator);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public static String getPathByDeletingPathExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getPathExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String getPathByDeletingLastComponent(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(string2)) == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getPathByDeletingLastComponent(String string) {
        return XJUtils.getPathByDeletingLastComponent(string, File.separator);
    }

    public static List sortedFilesInPath(String string) {
        File[] fileArray = new File(string).listFiles();
        List<File> list = Arrays.asList(fileArray);
        Collections.sort(list);
        return list;
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            char c3 = c = i + 1 < string.length() ? string.charAt(i + 1) : (char)'\u0000';
            if (c2 == '\\' && c != '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            if (c2 == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                ++i;
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object clone(Object object) throws Exception {
        Object object2 = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object2 = objectInputStream.readObject();
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        return object2;
    }

    public static void writeStringToFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        ((OutputStream)fileOutputStream).write(string.getBytes());
        ((OutputStream)fileOutputStream).close();
    }

    public static String getStringFromFile(String string) throws IOException {
        char[] cArray = null;
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            File file = new File(string);
            int n2 = (int)file.length();
            cArray = new char[n2];
            inputStreamReader = new FileReader(file);
            for (int i = 0; i < n2; i += n) {
                n = inputStreamReader.read(cArray, i, n2 - i);
                if (n != -1) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return new String(cArray);
    }

    protected static int[] parseVersionElement(String string) {
        int[] nArray = new int[]{0, 0, 0};
        int n = string.indexOf(VERSION_EA);
        if (n > 0) {
            nArray[0] = Integer.parseInt(string.substring(0, n));
            nArray[1] = -2;
            nArray[2] = Integer.parseInt(string.substring(n + VERSION_EA.length()));
        } else {
            n = string.indexOf(VERSION_BETA);
            if (n > 0) {
                nArray[0] = Integer.parseInt(string.substring(0, n));
                nArray[1] = -1;
                nArray[2] = Integer.parseInt(string.substring(n + VERSION_BETA.length()));
            } else {
                nArray[0] = Integer.parseInt(string);
            }
        }
        return nArray;
    }

    protected static int compareVersionElement(String string, String string2) {
        int[] nArray = XJUtils.parseVersionElement(string);
        int[] nArray2 = XJUtils.parseVersionElement(string2);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < nArray2[i]) {
                return -1;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isVersionGreaterThan(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == stringArray2.length) {
                return true;
            }
            switch (XJUtils.compareVersionElement(stringArray[i], stringArray2[i])) {
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return false;
    }

    public static String encodeToURL(String string) {
        return XJUtils.encodeToURL(string, "");
    }

    public static String encodeToURL(String string, String string2) {
        String string3 = string2;
        if (string != null && string.length() > 0) {
            try {
                string3 = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("XJUtils:encodeToURL exception: " + unsupportedEncodingException);
            }
        }
        return string3;
    }

    public static String getNormalizedText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String getLocalizedText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = XJSystem.getLineSeparator();
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
                stringBuffer.append(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String stackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static boolean deleteDirectory(String string) {
        return XJUtils.deleteDirectoryRecursively(new File(string));
    }

    private static boolean deleteDirectoryRecursively(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = XJUtils.deleteDirectoryRecursively(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }
}

