/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.utils;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.antlr.xjlib.appkit.gview.base.Vector2D;

public class XJSmoothScrolling
implements ActionListener {
    protected static final int steps = 10;
    protected JComponent c;
    protected Rectangle source;
    protected Rectangle dest;
    protected Vector2D v;
    protected int k;
    protected Timer timer;
    protected ScrollingDelegate delegate;

    public XJSmoothScrolling(JComponent jComponent, ScrollingDelegate scrollingDelegate) {
        this.c = jComponent;
        this.delegate = scrollingDelegate;
    }

    public synchronized void scrollTo(Rectangle rectangle) {
        this.dest = rectangle;
        this.computeSource();
        this.computeVector();
        if (this.c.getVisibleRect().intersects(rectangle)) {
            this.c.scrollRectToVisible(rectangle);
            this.completed();
        } else {
            this.startTimer();
        }
    }

    public synchronized void startTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(30, this);
        this.timer.start();
        this.k = 0;
    }

    public void completed() {
        if (this.delegate != null) {
            this.delegate.smoothScrollingDidComplete();
        }
    }

    public void computeVector() {
        this.v = new Vector2D(this.dest.x - this.source.x, this.dest.y - this.source.y);
    }

    public void computeSource() {
        Rectangle rectangle = this.c.getVisibleRect();
        this.source = new Rectangle(this.dest);
        if (this.source.x < rectangle.x) {
            this.source.x = rectangle.x;
        } else if (this.source.x > rectangle.x + rectangle.width) {
            this.source.x = rectangle.x + rectangle.width - this.source.width;
        }
        if (this.source.y < rectangle.y) {
            this.source.y = rectangle.y;
        } else if (this.source.y > rectangle.y + rectangle.height) {
            this.source.y = rectangle.y + rectangle.height - this.source.height;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.k;
        if (this.k > 10) {
            this.c.scrollRectToVisible(this.dest);
            this.timer.stop();
            this.timer = null;
            this.completed();
        } else {
            Rectangle rectangle = new Rectangle(this.source);
            rectangle.x = (int)((double)rectangle.x + this.v.x * (double)this.k / 10.0);
            rectangle.y = (int)((double)rectangle.y + this.v.y * (double)this.k / 10.0);
            this.c.scrollRectToVisible(rectangle);
        }
    }

    public static interface ScrollingDelegate {
        public void smoothScrollingDidComplete();
    }
}

