/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.utils;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileFilter;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJFileChooser {
    private static XJFileChooser shared = new XJFileChooser();
    private List<String> selectedFilePaths = null;
    private String selectedFilePath = null;
    private String selectedFileExtension = null;
    private static final String DEFAULT_DIR = "xjfilechooser.default.dir";

    public static XJFileChooser shared() {
        return shared;
    }

    public boolean displayOpenDialog(Component component, boolean bl) {
        return this.displayOpenDialog(component, null, (List<String>)null, false);
    }

    public boolean displayOpenDialog(Component component, String string, String string2, boolean bl) {
        return this.displayOpenDialog(component, Collections.singletonList(string), Collections.singletonList(string2), bl);
    }

    public boolean displayOpenDialog(Component component, List list, String string, boolean bl) {
        return this.displayOpenDialog(component, Collections.singletonList(list), Collections.singletonList(string), bl);
    }

    public boolean displayOpenDialog(Component component, List list, List<String> list2, boolean bl) {
        XJFileFilter xJFileFilter;
        if (component != null) {
            component = XJDialog.resolveOwner(component.getParent());
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(bl);
        if (list == null || list.size() == 0) {
            jFileChooser.setAcceptAllFileFilterUsed(true);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                xJFileFilter = XJFileFilter.createFileFilter(list.get(i), list2.get(i));
                jFileChooser.addChoosableFileFilter(xJFileFilter);
                if (list.size() != 1 || i != 0) continue;
                jFileChooser.setFileFilter(xJFileFilter);
            }
            if (list.size() > 1) {
                jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
            }
        }
        this.loadDefaultDirectory(jFileChooser);
        if (jFileChooser.showOpenDialog(component == null ? null : component) == 0) {
            FileFilter fileFilter;
            this.selectedFilePath = jFileChooser.getSelectedFile().getAbsolutePath();
            this.selectedFilePaths = this.filesToList(jFileChooser.getSelectedFiles());
            if (list != null && list.size() >= 0 && (fileFilter = jFileChooser.getFileFilter()) instanceof XJFileFilter) {
                xJFileFilter = (XJFileFilter)fileFilter;
                if (this.selectedFilePath.indexOf(".") == -1) {
                    this.selectedFilePath = this.selectedFilePath + "." + xJFileFilter.getDefaultExtension();
                }
            }
            this.saveCurrentDirectory(jFileChooser);
            return true;
        }
        return false;
    }

    private void loadDefaultDirectory(JFileChooser jFileChooser) {
        File file;
        String string = XJApplication.shared().getPreferences().getString(DEFAULT_DIR, null);
        if (string != null && (file = new File(string)).exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
    }

    private void saveCurrentDirectory(JFileChooser jFileChooser) {
        String string = jFileChooser.getSelectedFile().getAbsolutePath();
        if (!jFileChooser.getSelectedFile().isDirectory()) {
            string = XJUtils.getPathByDeletingLastComponent(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        XJApplication.shared().getPreferences().setString(DEFAULT_DIR, string);
    }

    private List<String> filesToList(File[] fileArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : fileArray) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    public boolean displaySaveDialog(Component component, String string, String string2, boolean bl) {
        return this.displaySaveDialog(component, Collections.singletonList(string), Collections.singletonList(string2), bl);
    }

    public boolean displaySaveDialog(Component component, List list, String string, boolean bl) {
        return this.displaySaveDialog(component, Collections.singletonList(list), Collections.singletonList(string), bl);
    }

    public boolean displaySaveDialog(Component component, List list, List<String> list2, boolean bl) {
        if (component != null) {
            component = XJDialog.resolveOwner(component.getParent());
        }
        JFileChooser jFileChooser = new JFileChooser();
        this.applyExtensions(list, jFileChooser, bl, list2);
        this.loadDefaultDirectory(jFileChooser);
        if (jFileChooser.showSaveDialog(component) == 0) {
            this.selectedFilePath = jFileChooser.getSelectedFile().getAbsolutePath();
            this.selectedFilePaths = this.filesToList(jFileChooser.getSelectedFiles());
            this.selectedFileExtension = this.getExtension(list, jFileChooser);
            if (this.selectedFileExtension != null && !this.selectedFilePath.endsWith("." + this.selectedFileExtension)) {
                this.selectedFilePath = this.selectedFilePath + "." + this.selectedFileExtension;
            }
            if (new File(this.selectedFilePath).exists()) {
                String string = XJUtils.getLastPathComponent(this.selectedFilePath);
                if (XJAlert.displayAlert(component, "Warning", "The file '" + string + "' already exists. Do you want to replace it?", "Cancel", "Replace", 1, 0) == 0) {
                    return false;
                }
            }
            this.saveCurrentDirectory(jFileChooser);
            return true;
        }
        return false;
    }

    public boolean displayChooseDirectory(Component component) {
        return this.displayChooseDirectory(component, null, null, true);
    }

    public boolean displayChooseDirectory(Component component, List list, List<String> list2, boolean bl) {
        JDialog jDialog;
        boolean bl2;
        if (component != null) {
            component = XJDialog.resolveOwner(component.getParent());
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select a directory");
        this.applyExtensions(list, jFileChooser, bl, list2);
        this.loadDefaultDirectory(jFileChooser);
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(component) == 0) {
            this.selectedFilePath = jFileChooser.getSelectedFile().getAbsolutePath();
            this.selectedFileExtension = this.getExtension(list, jFileChooser);
            if (!new File(this.selectedFilePath).exists()) {
                if (XJAlert.displayAlert(component, "Directory does not exist", "This directory does not exist. ANTLRWorks will create it if you choose to continue.", "Cancel", "Continue", 1, 0) == 1) {
                    new File(this.selectedFilePath).mkdirs();
                    this.saveCurrentDirectory(jFileChooser);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
            } else {
                this.saveCurrentDirectory(jFileChooser);
                bl2 = true;
            }
        } else {
            bl2 = false;
        }
        if (component instanceof JDialog && (jDialog = (JDialog)component).isModal()) {
            jDialog.toFront();
        }
        return bl2;
    }

    private String getExtension(List list, JFileChooser jFileChooser) {
        XJFileFilter xJFileFilter;
        FileFilter fileFilter;
        if (list != null && list.size() >= 0 && (fileFilter = jFileChooser.getFileFilter()) instanceof XJFileFilter && !(xJFileFilter = (XJFileFilter)fileFilter).accept(this.selectedFilePath)) {
            return xJFileFilter.getDefaultExtension();
        }
        return XJUtils.getPathExtension(this.selectedFilePath);
    }

    private void applyExtensions(List list, JFileChooser jFileChooser, boolean bl, List<String> list2) {
        if (list == null || list.size() == 0) {
            jFileChooser.setAcceptAllFileFilterUsed(bl);
        } else {
            jFileChooser.setAcceptAllFileFilterUsed(bl);
            XJFileFilter xJFileFilter = null;
            for (int i = 0; i < list.size(); ++i) {
                XJFileFilter xJFileFilter2 = XJFileFilter.createFileFilter(list.get(i), list2.get(i));
                jFileChooser.addChoosableFileFilter(xJFileFilter2);
                if (list.size() != 1 && bl || i != 0) continue;
                xJFileFilter = xJFileFilter2;
            }
            if (list.size() > 1 && bl) {
                jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
            } else {
                jFileChooser.setFileFilter(xJFileFilter);
            }
        }
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public List<String> getSelectedFilePaths() {
        return this.selectedFilePaths;
    }

    public String getSelectedFileExtension() {
        return this.selectedFileExtension;
    }

    static {
        if (XJSystem.isMacOS()) {
            UIManager.put("JFileChooser.appBundleIsTraversable", "always");
            UIManager.put("JFileChooser.packageIsTraversable", "always");
        }
    }
}

